package org.opoo.tools.tablediff;

import java.sql.SQLException;

@Deprecated
public interface TableDiffer {

    /**
     * 比对2个表，并返回比对结果。
     *
     * @param table1  表1
     * @param table2  表2
     * @param columns 字段信息
     * @return 比对结果
     * @throws SQLException SQL异常
     */
    default Result diff(Table table1, Table table2, Columns columns) throws SQLException {
        final Result result = new Result(table1.getName(), table2.getName());
        final ResultObserver observer = new ResultObserver(result);
        diff(table1, table2, columns, observer);
        return result;
    }

    /**
     * 比对 2 个表，并通过 Observer 监听比对过程和结果。
     *
     * @param table1   表1
     * @param table2   表2
     * @param columns  字段信息
     * @param observer 观察者
     * @throws SQLException SQL异常
     */
    default void diff(Table table1, Table table2, Columns columns, Observer observer) throws SQLException {
        final Comparison comparison = Comparison.builder()
                .table1(table1)
                .table2(table2)
                .columns(columns)
                .build();
        diff(comparison, observer);
    }

    /**
     * 比对 2 个表，并通过 Observer 监听比对过程和结果。
     *
     * @param comparison 比对参数
     * @param observer   观察者
     * @throws SQLException SQL异常
     */
    void diff(Comparison comparison, Observer observer) throws SQLException;
}
