/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db;

import org.opoo.tools.db.Table;

public class Column {
    private final String name;
    private final boolean primaryKey;
    private Class<?> type;
    private int sqlType = Integer.MIN_VALUE;
    private transient Table table;

    public Column(String name) {
        this.name = name;
        this.primaryKey = false;
    }

    public Column(String name, boolean primaryKey) {
        this.name = name;
        this.primaryKey = primaryKey;
    }

    public Column withType(Class<?> type) {
        this.type = type;
        return this;
    }

    public Column withSqlType(int sqlType) {
        this.sqlType = sqlType;
        return this;
    }

    void setTable(Table table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Class<?> getType() {
        return this.type;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public Table getTable() {
        return this.table;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrimaryKey() != other.isPrimaryKey()) {
            return false;
        }
        if (this.getSqlType() != other.getSqlType()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrimaryKey() ? 79 : 97);
        result = result * 59 + this.getSqlType();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", primaryKey=" + this.isPrimaryKey() + ", type=" + this.getType() + ", sqlType=" + this.getSqlType() + ")";
    }
}

