/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db;

import java.util.Arrays;
import java.util.Objects;

public class Id
implements Comparable<Id> {
    private final Object[] values;

    public Id(Object ... values) {
        for (Object value : values) {
            if (value instanceof Comparable) continue;
            throw new IllegalArgumentException("id value must be comparable");
        }
        this.values = values;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    @Override
    public int compareTo(Id id) {
        Objects.requireNonNull(id, "id must not be null");
        if (id == this) {
            return 0;
        }
        if (id.values.length != this.values.length) {
            throw new IllegalArgumentException("id lengths do not match");
        }
        for (int i = 0; i < this.values.length; ++i) {
            int result = ((Comparable)this.values[i]).compareTo(id.values[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public Object[] getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Id)) {
            return false;
        }
        Id other = (Id)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getValues(), other.getValues());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Id;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getValues());
        return result;
    }
}

