/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.opoo.tools.db.Column;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class Table {
    private final String name;
    private final Column[] columns;
    private String whereCondition;
    private final Map<String, Column> columnsMap = new LinkedCaseInsensitiveMap();
    private final Column[] primaryKeyColumns;
    private final Column[] normalColumns;

    public Table(String name, Column ... columns) {
        Assert.isTrue((columns.length > 0 ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u6570\u5fc5\u987b\u5927\u4e8e 0");
        this.name = name;
        ArrayList<Column> primaryKeyColumnList = new ArrayList<Column>();
        ArrayList<Column> normalColumnList = new ArrayList<Column>();
        for (Column column : columns) {
            column.setTable(this);
            this.columnsMap.put(column.getName(), column);
            if (column.isPrimaryKey()) {
                primaryKeyColumnList.add(column);
                continue;
            }
            normalColumnList.add(column);
        }
        Assert.isTrue((!primaryKeyColumnList.isEmpty() ? 1 : 0) != 0, (String)"\u4e3b\u952e\u5b57\u6bb5\u6570\u5fc5\u987b\u5927\u4e8e 0");
        this.primaryKeyColumns = primaryKeyColumnList.toArray(new Column[0]);
        this.normalColumns = normalColumnList.toArray(new Column[0]);
        this.columns = new Column[columns.length];
        System.arraycopy(this.primaryKeyColumns, 0, this.columns, 0, this.primaryKeyColumns.length);
        System.arraycopy(this.normalColumns, 0, this.columns, this.primaryKeyColumns.length, this.normalColumns.length);
    }

    public Table withWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public String getWhereCondition() {
        return this.whereCondition;
    }

    public Map<String, Column> getColumnsMap() {
        return this.columnsMap;
    }

    public Column[] getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public Column[] getNormalColumns() {
        return this.normalColumns;
    }

    public void setWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColumns(), other.getColumns())) {
            return false;
        }
        String this$whereCondition = this.getWhereCondition();
        String other$whereCondition = other.getWhereCondition();
        if (this$whereCondition == null ? other$whereCondition != null : !this$whereCondition.equals(other$whereCondition)) {
            return false;
        }
        Map<String, Column> this$columnsMap = this.getColumnsMap();
        Map<String, Column> other$columnsMap = other.getColumnsMap();
        if (this$columnsMap == null ? other$columnsMap != null : !((Object)this$columnsMap).equals(other$columnsMap)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPrimaryKeyColumns(), other.getPrimaryKeyColumns())) {
            return false;
        }
        return Arrays.deepEquals(this.getNormalColumns(), other.getNormalColumns());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getColumns());
        String $whereCondition = this.getWhereCondition();
        result = result * 59 + ($whereCondition == null ? 43 : $whereCondition.hashCode());
        Map<String, Column> $columnsMap = this.getColumnsMap();
        result = result * 59 + ($columnsMap == null ? 43 : ((Object)$columnsMap).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPrimaryKeyColumns());
        result = result * 59 + Arrays.deepHashCode(this.getNormalColumns());
        return result;
    }

    public String toString() {
        return "Table(name=" + this.getName() + ", columns=" + Arrays.deepToString(this.getColumns()) + ", whereCondition=" + this.getWhereCondition() + ")";
    }
}

