/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db.copy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.opoo.tools.db.ArgumentSetter;
import org.opoo.tools.db.Column;
import org.opoo.tools.db.Id;
import org.opoo.tools.db.SqlAndParams;
import org.opoo.tools.db.Table;
import org.opoo.tools.db.copy.SameDbTableCopier;
import org.opoo.tools.db.util.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class AbstractSameDbTableCopier
implements SameDbTableCopier {
    private static final Logger log = LoggerFactory.getLogger(AbstractSameDbTableCopier.class);

    @Override
    public int copy(Connection connection, Table sourceTable, Table targetTable, int batchSize) throws SQLException {
        this.validate(sourceTable, targetTable);
        Id previousOffsetId = null;
        int count = 0;
        while (true) {
            Id offsetId = this.getOffsetId(connection, sourceTable, batchSize, previousOffsetId);
            count += this.batchCopy(connection, sourceTable, targetTable, previousOffsetId, offsetId);
            if (offsetId == null) break;
            previousOffsetId = offsetId;
        }
        log.info("\u590d\u5236\u8868 {} => {} \u5b8c\u6210\uff0c\u66f4\u65b0\u6570\u636e {} \u9879", new Object[]{sourceTable.getName(), targetTable.getName(), count});
        return count;
    }

    /*
     * Exception decompiling
     */
    protected Id getOffsetId(Connection connection, Table table, int batchSize, Id previousOffsetId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int batchCopy(Connection connection, Table sourceTable, Table targetTable, Id previousOffsetId, Id offsetId) throws SQLException {
        SqlAndParams sqlAndParams = this.buildCopySql(sourceTable, targetTable, previousOffsetId, offsetId);
        String sql = sqlAndParams.getSql();
        log.debug("\u533a\u95f4\u590d\u5236 ({}, {}]: {}", new Object[]{previousOffsetId, offsetId, sql});
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            new ArgumentSetter(sqlAndParams.getParams()).setValues(ps);
            int n = ps.executeUpdate();
            return n;
        }
    }

    protected abstract SqlAndParams buildGetOffsetIdSql(Table var1, int var2, Id var3);

    protected SqlAndParams buildCopySql(Table sourceTable, Table targetTable, @Nullable Id previousOffsetId, @Nullable Id offsetId) {
        String[] primaryKeyNames = (String[])Arrays.stream(sourceTable.getPrimaryKeyColumns()).map(Column::getName).toArray(String[]::new);
        String whereCondition = sourceTable.getWhereCondition();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder().append("INSERT INTO ").append(targetTable.getName()).append("(").append(Arrays.stream(targetTable.getColumns()).map(Column::getName).collect(Collectors.joining(", "))).append(") SELECT ").append(Arrays.stream(sourceTable.getColumns()).map(Column::getName).collect(Collectors.joining(", "))).append(" FROM ").append(sourceTable.getName());
        boolean wherePresent = false;
        if (previousOffsetId != null) {
            SqlAndParams idCondition = DbUtils.buildGreaterThanCondition(primaryKeyNames, previousOffsetId.getValues());
            sql.append(" WHERE ").append(idCondition.getSql());
            params.addAll(idCondition.getParams());
            wherePresent = true;
        }
        if (offsetId != null) {
            SqlAndParams offsetIdCondition = DbUtils.buildLessThanOrEqualsCondition(primaryKeyNames, offsetId.getValues());
            sql.append(wherePresent ? " AND " : " WHERE ").append(offsetIdCondition.getSql());
            params.addAll(offsetIdCondition.getParams());
            wherePresent = true;
        }
        if (StringUtils.hasText((String)whereCondition)) {
            if (wherePresent) {
                sql.append(" AND (").append(whereCondition).append(")");
            } else {
                sql.append(" WHERE ").append(whereCondition);
            }
        }
        return new SqlAndParams(sql.toString(), params);
    }

    private void validate(Table sourceTable, Table targetTable) {
        if (sourceTable.getColumns().length != targetTable.getColumns().length) {
            throw new IllegalArgumentException("sourceTable and targetTable must have the same number of columns");
        }
        if (sourceTable.getPrimaryKeyColumns().length != targetTable.getPrimaryKeyColumns().length) {
            throw new IllegalArgumentException("sourceTable and targetTable must have the same number of primary key columns");
        }
    }
}

