/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db.copy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opoo.tools.db.Column;
import org.opoo.tools.db.Id;
import org.opoo.tools.db.SqlAndParams;
import org.opoo.tools.db.Table;
import org.opoo.tools.db.copy.AbstractSameDbTableCopier;
import org.opoo.tools.db.util.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class MySQLSameDbTableCopier
extends AbstractSameDbTableCopier {
    private static final Logger log = LoggerFactory.getLogger(MySQLSameDbTableCopier.class);
    private boolean usingOnDuplicateKeyUpdate = false;

    @Override
    protected SqlAndParams buildGetOffsetIdSql(Table table, int batchSize, Id previousOffsetId) {
        CharSequence[] primaryKeyNames = (String[])Arrays.stream(table.getPrimaryKeyColumns()).map(Column::getName).toArray(String[]::new);
        String primaryKeyJoinString = String.join((CharSequence)", ", primaryKeyNames);
        String whereCondition = table.getWhereCondition();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder("SELECT " + primaryKeyJoinString + " FROM " + table.getName());
        if (previousOffsetId != null) {
            SqlAndParams idCondition = DbUtils.buildGreaterThanCondition((String[])primaryKeyNames, previousOffsetId.getValues());
            sql.append(" WHERE ").append(idCondition.getSql());
            params.addAll(idCondition.getParams());
        }
        if (StringUtils.hasText((String)whereCondition)) {
            if (previousOffsetId != null) {
                sql.append(" AND (").append(whereCondition).append(")");
            } else {
                sql.append(" WHERE ").append(whereCondition);
            }
        }
        sql.append(" ORDER BY ").append(primaryKeyJoinString).append(" LIMIT 1 OFFSET ?");
        params.add(batchSize - 1);
        return new SqlAndParams(sql.toString(), params);
    }

    @Override
    protected SqlAndParams buildCopySql(Table sourceTable, Table targetTable, @Nullable Id previousOffsetId, @Nullable Id offsetId) {
        SqlAndParams sqlAndParams = super.buildCopySql(sourceTable, targetTable, previousOffsetId, offsetId);
        if (!this.usingOnDuplicateKeyUpdate) {
            return sqlAndParams;
        }
        StringBuilder sql = new StringBuilder(sqlAndParams.getSql());
        List<Object> params = sqlAndParams.getParams();
        sql.append(" ON DUPLICATE KEY UPDATE ");
        Column[] normalColumnsB = targetTable.getNormalColumns();
        int size = normalColumnsB.length;
        for (int i = 0; i < size; ++i) {
            sql.append(normalColumnsB[i].getName()).append(" = VALUES(").append(normalColumnsB[i].getName()).append(")");
            if (i >= size - 1) continue;
            sql.append(", ");
        }
        return new SqlAndParams(sql.toString(), params);
    }

    public void setUsingOnDuplicateKeyUpdate(boolean usingOnDuplicateKeyUpdate) {
        this.usingOnDuplicateKeyUpdate = usingOnDuplicateKeyUpdate;
    }
}

