/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db.copy;

import org.opoo.tools.db.Column;
import org.opoo.tools.db.Table;
import org.opoo.tools.db.copy.SimpleTableCopier;

public class MySQLTableCopier
extends SimpleTableCopier {
    private boolean usingOnDuplicateKeyUpdate = false;

    @Override
    protected String buildInsertSql(Table sourceTable, Table targetTable) {
        String sql = super.buildInsertSql(sourceTable, targetTable);
        if (!this.usingOnDuplicateKeyUpdate) {
            return sql;
        }
        StringBuilder stringBuilder = new StringBuilder(sql).append(" as n ON DUPLICATE KEY UPDATE ");
        Column[] normalColumns2 = targetTable.getNormalColumns();
        for (int i = 0; i < normalColumns2.length; ++i) {
            stringBuilder.append(normalColumns2[i].getName()).append(" = n.").append(normalColumns2[i].getName());
            if (i >= normalColumns2.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public void setUsingOnDuplicateKeyUpdate(boolean usingOnDuplicateKeyUpdate) {
        this.usingOnDuplicateKeyUpdate = usingOnDuplicateKeyUpdate;
    }
}

