/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db.copy;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.opoo.tools.db.Column;
import org.opoo.tools.db.SqlBiConsumer;
import org.opoo.tools.db.Table;
import org.opoo.tools.db.TableInput;
import org.opoo.tools.db.copy.TableCopier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.StringUtils;

public class SimpleTableCopier
implements TableCopier {
    private static final Logger log = LoggerFactory.getLogger(SimpleTableCopier.class);

    /*
     * Exception decompiling
     */
    @Override
    public int copy(TableInput source, TableInput target, int batchSize, SqlBiConsumer<ResultSet, PreparedStatement> recordCopier) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String buildQuerySql(Table table) {
        String allComlumnsString = Arrays.stream(table.getColumns()).map(Column::getName).collect(Collectors.joining(", "));
        String primaryKeysJoinString = Arrays.stream(table.getPrimaryKeyColumns()).map(Column::getName).collect(Collectors.joining(", "));
        String whereCondition = table.getWhereCondition();
        StringBuilder sql = new StringBuilder().append("SELECT ").append(allComlumnsString).append(" FROM ").append(table.getName());
        if (StringUtils.hasText((String)whereCondition)) {
            sql.append(" WHERE ").append(whereCondition);
        }
        sql.append(" ORDER BY ").append(primaryKeysJoinString);
        return sql.toString();
    }

    protected String buildInsertSql(Table sourceTable, Table targetTable) {
        Column[] columns = targetTable.getColumns();
        Object[] questionMarks = new String[columns.length];
        Arrays.fill(questionMarks, "?");
        return "INSERT INTO " + targetTable.getName() + " (" + Arrays.stream(columns).map(Column::getName).collect(Collectors.joining(", ")) + ") VALUES (" + String.join((CharSequence)", ", (CharSequence[])questionMarks) + ")";
    }

    protected PreparedStatement createQueryStatement(Connection conn, String sql) throws SQLException {
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        String databaseProductName = databaseMetaData.getDatabaseProductName();
        PreparedStatement ps = conn.prepareStatement(sql, 1003, 1007);
        if (databaseProductName.startsWith("Oracle")) {
            ps.setFetchSize(10000);
        } else if (databaseProductName.startsWith("MySQL") || databaseProductName.startsWith("MariaDB")) {
            ps.setFetchSize(Integer.MIN_VALUE);
        }
        return ps;
    }

    protected PreparedStatement createInsertStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    protected int copyAllRecords(CopyParams params, ResultSet rs, PreparedStatement ps) throws SQLException {
        int batchSize = params.getBatchSize();
        long start = System.currentTimeMillis();
        int total = 0;
        int count = 0;
        while (rs.next()) {
            this.copyRecord(params, rs, ps);
            ps.addBatch();
            if (++count < batchSize) continue;
            ps.executeBatch();
            total += count;
            count = 0;
            this.logBatch(start, total);
        }
        if (count > 0) {
            ps.executeBatch();
            this.logBatch(start, total += count);
        }
        log.info("\u590d\u5236 {} => {} \u5b8c\u6210\uff0c\u5171 {} \u9879", new Object[]{params.getSourceTable().getName(), params.getTargetTable().getName(), total});
        return total;
    }

    protected void copyRecord(CopyParams params, ResultSet rs, PreparedStatement ps) throws SQLException {
        SqlBiConsumer<ResultSet, PreparedStatement> recordCopier = params.getRecordCopier();
        if (recordCopier != null) {
            recordCopier.apply(rs, ps);
            return;
        }
        Table sourceTable = params.getSourceTable();
        Table targetTable = params.getTargetTable();
        Column[] columns1 = sourceTable.getColumns();
        Column[] columns2 = targetTable.getColumns();
        for (int i = 0; i < columns1.length; ++i) {
            Object value = JdbcUtils.getResultSetValue((ResultSet)rs, (int)(i + 1), columns1[i].getType());
            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)columns2[i].getSqlType(), (Object)value);
        }
    }

    private void logBatch(long start, int total) {
        log.debug("\u6279\u6b21\u590d\u5236\u5b8c\u6210\uff0c\u5f53\u524d\u8bb0\u5f55 {}, \u8017\u65f6 {}ms", (Object)total, (Object)(System.currentTimeMillis() - start));
    }

    protected static class CopyParams {
        private final Table sourceTable;
        private final Table targetTable;
        private final int batchSize;
        private final SqlBiConsumer<ResultSet, PreparedStatement> recordCopier;

        public CopyParams(Table sourceTable, Table targetTable, int batchSize, SqlBiConsumer<ResultSet, PreparedStatement> recordCopier) {
            this.sourceTable = sourceTable;
            this.targetTable = targetTable;
            this.batchSize = batchSize;
            this.recordCopier = recordCopier;
        }

        public Table getSourceTable() {
            return this.sourceTable;
        }

        public Table getTargetTable() {
            return this.targetTable;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public SqlBiConsumer<ResultSet, PreparedStatement> getRecordCopier() {
            return this.recordCopier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CopyParams)) {
                return false;
            }
            CopyParams other = (CopyParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBatchSize() != other.getBatchSize()) {
                return false;
            }
            Table this$sourceTable = this.getSourceTable();
            Table other$sourceTable = other.getSourceTable();
            if (this$sourceTable == null ? other$sourceTable != null : !((Object)this$sourceTable).equals(other$sourceTable)) {
                return false;
            }
            Table this$targetTable = this.getTargetTable();
            Table other$targetTable = other.getTargetTable();
            if (this$targetTable == null ? other$targetTable != null : !((Object)this$targetTable).equals(other$targetTable)) {
                return false;
            }
            SqlBiConsumer<ResultSet, PreparedStatement> this$recordCopier = this.getRecordCopier();
            SqlBiConsumer<ResultSet, PreparedStatement> other$recordCopier = other.getRecordCopier();
            return !(this$recordCopier == null ? other$recordCopier != null : !this$recordCopier.equals(other$recordCopier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CopyParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBatchSize();
            Table $sourceTable = this.getSourceTable();
            result = result * 59 + ($sourceTable == null ? 43 : ((Object)$sourceTable).hashCode());
            Table $targetTable = this.getTargetTable();
            result = result * 59 + ($targetTable == null ? 43 : ((Object)$targetTable).hashCode());
            SqlBiConsumer<ResultSet, PreparedStatement> $recordCopier = this.getRecordCopier();
            result = result * 59 + ($recordCopier == null ? 43 : $recordCopier.hashCode());
            return result;
        }

        public String toString() {
            return "SimpleTableCopier.CopyParams(sourceTable=" + this.getSourceTable() + ", targetTable=" + this.getTargetTable() + ", batchSize=" + this.getBatchSize() + ", recordCopier=" + this.getRecordCopier() + ")";
        }
    }
}

