/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db.diff;

import java.sql.SQLException;
import java.util.List;
import org.opoo.tools.db.Database;
import org.opoo.tools.db.DatabaseInput;
import org.opoo.tools.db.TableNameInput;
import org.opoo.tools.db.diff.DatabaseComparator;
import org.opoo.tools.db.diff.DatabaseListener;
import org.opoo.tools.db.diff.SimpleTableComparator;
import org.opoo.tools.db.diff.TableComparator;
import org.opoo.tools.db.diff.TableListener;
import org.opoo.tools.db.diff.TableResult;
import org.opoo.tools.db.diff.TableResultListener;
import org.opoo.tools.db.util.DbUtils;
import org.opoo.tools.db.util.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDatabaseComparator
implements DatabaseComparator {
    private static final Logger log = LoggerFactory.getLogger(SimpleDatabaseComparator.class);
    private final TableComparator tableComparator;

    public SimpleDatabaseComparator() {
        this.tableComparator = new SimpleTableComparator();
    }

    public SimpleDatabaseComparator(TableComparator tableComparator) {
        this.tableComparator = tableComparator;
    }

    @Override
    public void compare(DatabaseInput dbA, DatabaseInput dbB, DatabaseListener listener) throws SQLException {
        Database databaseA = dbA.getDatabase();
        Database databaseB = dbB.getDatabase();
        List<String> tableNamesA = DbUtils.getTableNames(databaseA.getCatalog(), databaseA.getTableNamePattern(), databaseA.getTableNamePattern(), dbA.getConnection());
        List<String> tableNamesB = DbUtils.getTableNames(databaseB.getCatalog(), databaseB.getTableNamePattern(), databaseB.getTableNamePattern(), dbB.getConnection());
        List<String> tableNamesOnlyInDbA = ListUtils.removeAllIgnoreCase(tableNamesA, tableNamesB);
        List<String> tableNamesOnlyInDbB = ListUtils.removeAllIgnoreCase(tableNamesB, tableNamesA);
        List<String> tableNames = ListUtils.intersectionIgnoreCase(tableNamesA, tableNamesB);
        tableNamesOnlyInDbA.forEach(listener::onOnlyInDbA);
        tableNamesOnlyInDbB.forEach(listener::onOnlyInDbB);
        for (String tableName : tableNames) {
            TableResult result = TableResult.arrayListResult(tableName + "@A", tableName + "@B");
            TableResultListener resultListener = new TableResultListener(result);
            try {
                this.tableComparator.compare(new TableNameInput(tableName, dbA.getConnection()), new TableNameInput(tableName, dbB.getConnection()), (TableListener)resultListener);
            }
            catch (Exception ex) {
                listener.onTableException(tableName, ex);
            }
            if (result.getIdsDifferent().isEmpty() && result.getIdsOnlyInA().isEmpty() && result.getIdsOnlyInB().isEmpty()) {
                listener.onIdentical(tableName);
                continue;
            }
            listener.onTableDifferent(tableName, result);
        }
    }
}

