/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.db.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opoo.tools.db.Column;
import org.opoo.tools.db.Id;
import org.opoo.tools.db.SqlAndParams;
import org.opoo.tools.db.SqlSupplier;
import org.opoo.tools.db.Table;
import org.opoo.tools.db.util.SqlTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.JdbcUtils;

public final class DbUtils {
    private static final Logger log = LoggerFactory.getLogger(DbUtils.class);

    public static Id getNextId(Table table, ResultSet resultSet) throws SQLException {
        return DbUtils.getNextId(table.getPrimaryKeyColumns(), resultSet);
    }

    public static Id getNextId(Column[] primaryKeys, ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return DbUtils.getId(primaryKeys, resultSet);
        }
        return null;
    }

    public static Id getId(Column[] primaryKeys, ResultSet resultSet) throws SQLException {
        Object[] values = new Object[primaryKeys.length];
        for (int i = 0; i < primaryKeys.length; ++i) {
            values[i] = JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)(i + 1), primaryKeys[i].getType());
        }
        return new Id(values);
    }

    public static void initializeColumnTypes(ResultSet rs, Column[] columns) throws SQLException {
        boolean allMatch = Arrays.stream(columns).allMatch(c -> Objects.nonNull(c.getType()));
        if (allMatch) {
            log.debug("\u5bf9\u5e94\u5b57\u6bb5\u90fd\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u7c7b\u578b\uff0c\u4e0d\u5fc5\u518d\u5904\u7406");
            return;
        }
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!Objects.isNull(column.getType())) continue;
            int columnType = resultSetMetaData.getColumnType(i + 1);
            column.setSqlType(columnType);
            Class<?> type = SqlTypeUtils.sqlTypeToClass(columnType);
            column.setType(type);
            if (!log.isDebugEnabled()) continue;
            log.debug("\u8868[{}]\u5217[{}]\u89e3\u6790\u503c\u7c7b\u578b\uff1a{}/{}", new Object[]{column.getTable().getName(), column.getName(), columnType, type});
        }
    }

    public static <T> T orElse(T obj, SqlSupplier<T> supplier) throws SQLException {
        if (obj == null) {
            return supplier.get();
        }
        return obj;
    }

    public static String getCatalog(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getSchema(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getSchema();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static Table buildTable(String tableName, Connection conn) throws SQLException {
        return DbUtils.buildTable(DbUtils.getCatalog(conn), DbUtils.getSchema(conn), tableName, conn);
    }

    public static Table buildTable(String catalog, String schemaPattern, String tableName, Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try (ResultSet rs = metaData.getPrimaryKeys(DbUtils.getCatalog(conn), DbUtils.getSchema(conn), tableName);){
            while (rs.next()) {
                primaryKeys.add(rs.getString("COLUMN_NAME"));
            }
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        try (ResultSet columns = metaData.getColumns(catalog, schemaPattern, tableName, null);){
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                boolean isPrimaryKey = primaryKeys.contains(columnName);
                int dataType = columns.getInt("DATA_TYPE");
                Class<?> type = SqlTypeUtils.sqlTypeToClass(dataType);
                Column column = new Column(columnName, isPrimaryKey).withType(type).withSqlType(dataType);
                columnList.add(column);
            }
        }
        log.debug("table {}: {}", (Object)tableName, columnList);
        return new Table(tableName, columnList.toArray(new Column[0]));
    }

    public static List<String> getTableNames(Connection conn) throws SQLException {
        return DbUtils.getTableNames(DbUtils.getCatalog(conn), DbUtils.getSchema(conn), "%", conn);
    }

    public static List<String> getTableNames(String catalog, String schemaPattern, String tableNamePattern, Connection conn) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        DatabaseMetaData metaData = conn.getMetaData();
        try (ResultSet tables = metaData.getTables(catalog, schemaPattern, tableNamePattern, new String[]{"TABLE"});){
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
        }
        return tableNames;
    }

    public static SqlAndParams buildGreaterThanCondition(String[] columnNames, Object[] values) {
        return DbUtils.buildCondition(columnNames, values, true, false);
    }

    public static SqlAndParams buildLessThanCondition(String[] columnNames, Object[] values) {
        return DbUtils.buildCondition(columnNames, values, false, false);
    }

    public static SqlAndParams buildGreaterThanOrEqualsCondition(String[] columnNames, Object[] values) {
        return DbUtils.buildCondition(columnNames, values, true, true);
    }

    public static SqlAndParams buildLessThanOrEqualsCondition(String[] columnNames, Object[] values) {
        return DbUtils.buildCondition(columnNames, values, false, true);
    }

    public static SqlAndParams buildCondition(String[] columnNames, Object[] values, boolean greaterThan, boolean includeEquals) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder condition = new StringBuilder();
        int length = columnNames.length;
        int maxIndex = length - 1;
        if (length > 1) {
            condition.append("(");
        }
        for (int i = 0; i <= maxIndex; ++i) {
            if (i > 0) {
                condition.append(" OR ");
            }
            condition.append("(");
            for (int j = 0; j <= i; ++j) {
                if (j > 0) {
                    condition.append(" AND ");
                }
                condition.append(columnNames[j]);
                params.add(values[j]);
                if (j < i) {
                    condition.append(" = ?");
                    continue;
                }
                condition.append(greaterThan ? " >" : " <");
                condition.append(includeEquals && j == maxIndex ? "=" : "");
                condition.append(" ?");
            }
            condition.append(")");
        }
        if (length > 1) {
            condition.append(")");
        }
        return new SqlAndParams(condition.toString(), params);
    }

    private DbUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

