/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.tools.tablediff;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.opoo.tools.tablediff.Columns;
import org.opoo.tools.tablediff.Comparison;
import org.opoo.tools.tablediff.Id;
import org.opoo.tools.tablediff.Observer;
import org.opoo.tools.tablediff.Table;
import org.opoo.tools.tablediff.TableDiffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractTableDiffer
implements TableDiffer {
    private static final Logger log = LoggerFactory.getLogger(AbstractTableDiffer.class);

    @Override
    public void diff(Comparison comparison, Observer observer) throws SQLException {
        Table table1 = comparison.getTable1();
        Table table2 = comparison.getTable2();
        Columns columns = comparison.getColumns();
        Id startId = comparison.getStartId();
        try (Connection conn1 = table1.getDataSource().getConnection();
             Connection conn2 = table2.getDataSource().getConnection();
             PreparedStatement ps1 = this.preparedStatement(conn1, table1.getName(), columns, startId);
             PreparedStatement ps2 = this.preparedStatement(conn2, table2.getName(), columns, startId);
             ResultSet rs1 = ps1.executeQuery();
             ResultSet rs2 = ps2.executeQuery();){
            Context context = this.buildContext(rs1, columns);
            Status status = Status.CONTINUE;
            while (status == Status.CONTINUE) {
                status = this.compare(context, rs1, rs2, columns, observer);
            }
        }
    }

    protected PreparedStatement preparedStatement(Connection conn, String tableName, Columns columns, Id startId) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        AbstractTableDiffer.buildSql(tableName, columns, startId, sqlBuilder, params);
        String sql = sqlBuilder.toString();
        log.debug("Executing query: {}", (Object)sql);
        PreparedStatement ps = conn.prepareStatement(sql, 1003, 1007);
        ps.setFetchSize(Integer.MIN_VALUE);
        if (startId != null) {
            log.debug("Start id from(exclusive): {}", (Object)startId);
            for (int i = 0; i < params.size(); ++i) {
                ps.setObject(i + 1, params.get(i));
            }
        }
        return ps;
    }

    protected static void buildSql(String tableName, Columns columns, Id startId, StringBuilder stringBuilder, List<Object> params) {
        CharSequence[] pkNames = columns.getPkNames();
        String pkNamesJoinString = String.join((CharSequence)", ", pkNames);
        stringBuilder.append("SELECT ").append(pkNamesJoinString).append(", ").append(String.join((CharSequence)", ", columns.getNames())).append(" FROM ").append(tableName);
        if (startId != null) {
            stringBuilder.append(" WHERE ");
            AbstractTableDiffer.buildSqlWhere((String[])pkNames, startId.getValues(), stringBuilder, params);
        }
        stringBuilder.append(" ORDER BY ").append(pkNamesJoinString);
    }

    protected static void buildSqlWhere(String[] pkNames, Object[] startIdValues, StringBuilder stringBuilder, List<Object> params) {
        for (int i = 0; i < pkNames.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" or ");
                stringBuilder.append("(");
            }
            for (int j = 0; j <= i; ++j) {
                if (j > 0) {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append(pkNames[j]);
                params.add(startIdValues[j]);
                if (j < i) {
                    stringBuilder.append(" = ?");
                    continue;
                }
                stringBuilder.append(" > ?");
            }
            if (i <= 0) continue;
            stringBuilder.append(")");
        }
    }

    protected Status compare(Context context, ResultSet rs1, ResultSet rs2, Columns columns, Observer observer) throws SQLException {
        Id id2;
        Id id1 = context.id1 == null ? this.getNextId(rs1, context) : context.id1;
        Id id = id2 = context.id2 == null ? this.getNextId(rs2, context) : context.id2;
        if (id1 == null && id2 == null) {
            return Status.FINISHED;
        }
        log.debug("id1 = {}, id2 = {}", (Object)id1, (Object)id2);
        if (id1 == null) {
            observer.updateOnlyIn2(id2);
            this.addRemainIds(rs2, context, observer::updateOnlyIn2);
            return Status.FINISHED;
        }
        if (id2 == null) {
            observer.updateOnlyIn1(id1);
            this.addRemainIds(rs1, context, observer::updateOnlyIn1);
            return Status.FINISHED;
        }
        int compareTo = id1.compareTo(id2);
        if (compareTo < 0) {
            observer.updateOnlyIn1(id1);
            context.update(null, id2);
        } else if (compareTo > 0) {
            observer.updateOnlyIn2(id2);
            context.update(id1, null);
        } else {
            if (this.equals(rs1, rs2, id1, context, columns)) {
                observer.updateIdentical(id1);
            } else {
                observer.updateDifferent(id1);
            }
            context.update(null, null);
        }
        return Status.CONTINUE;
    }

    protected Id getNextId(ResultSet resultSet, Context context) throws SQLException {
        if (resultSet.next()) {
            int pkNamesCount = context.getPkNamesCount();
            Object[] id = new Object[pkNamesCount];
            for (int i = 0; i < pkNamesCount; ++i) {
                id[i] = resultSet.getObject(i + 1, context.getPkTypes()[i]);
            }
            return new Id(id);
        }
        return null;
    }

    protected Context buildContext(ResultSet resultSet, Columns columns) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int pkNamesCount = columns.getPkNames().length;
        Class<?>[] pkTypes = columns.getPkTypes();
        Class<?>[] types = columns.getTypes();
        if (pkTypes == null) {
            pkTypes = new Class[pkNamesCount];
            for (int i = 0; i < pkNamesCount; ++i) {
                pkTypes[i] = this.sqlTypeToClass(metaData.getColumnType(i + 1));
            }
        }
        if (types == null) {
            int namesCount = columns.getNames().length;
            types = new Class[namesCount];
            for (int i = 0; i < namesCount; ++i) {
                types[i] = this.sqlTypeToClass(metaData.getColumnType(pkNamesCount + i + 1));
            }
        }
        log.debug("pk types = {}, other column types ={}", pkTypes, types);
        return new Context(pkTypes, types);
    }

    protected Class<?> sqlTypeToClass(int sqlType) {
        switch (sqlType) {
            case 16: {
                return Boolean.class;
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 3: {
                return BigDecimal.class;
            }
            case 6: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 91: 
            case 92: 
            case 93: {
                return Date.class;
            }
            case 2004: {
                return byte[].class;
            }
        }
        return String.class;
    }

    protected void addRemainIds(ResultSet rs, Context context, Consumer<Id> idConsumer) throws SQLException {
        Id nextId;
        while ((nextId = this.getNextId(rs, context)) != null) {
            idConsumer.accept(nextId);
        }
    }

    protected boolean equals(ResultSet rs1, ResultSet rs2, Id id, Context context, Columns columns) throws SQLException {
        int pkNamesCount = context.getPkNamesCount();
        int namesCount = context.getNamesCount();
        Class<?>[] columnTypes = context.getTypes();
        for (int i = 0; i < namesCount; ++i) {
            Object val2;
            Class<?> columnType = columnTypes[i];
            Object val1 = rs1.getObject(pkNamesCount + i + 1, columnType);
            if (Objects.equals(val1, val2 = rs2.getObject(pkNamesCount + i + 1, columnType))) continue;
            log.info("Difference found: id = {}, column name = '{}', value1 ='{}', value2 = '{}'", new Object[]{id, columns.getNames()[i], val1, val2});
            return false;
        }
        return true;
    }

    protected static enum Status {
        FINISHED,
        CONTINUE;

    }

    protected static class Context {
        private final Class<?>[] pkTypes;
        private final Class<?>[] types;
        private final int pkNamesCount;
        private final int namesCount;
        private Id id1;
        private Id id2;

        protected Context(Class<?>[] pkTypes, Class<?>[] types) {
            this.pkTypes = pkTypes;
            this.types = types;
            this.pkNamesCount = pkTypes.length;
            this.namesCount = types.length;
        }

        public void update(Id id1, Id id2) {
            this.id1 = id1;
            this.id2 = id2;
        }

        public Class<?>[] getPkTypes() {
            return this.pkTypes;
        }

        public Class<?>[] getTypes() {
            return this.types;
        }

        public int getPkNamesCount() {
            return this.pkNamesCount;
        }

        public int getNamesCount() {
            return this.namesCount;
        }

        public Id getId1() {
            return this.id1;
        }

        public Id getId2() {
            return this.id2;
        }

        public void setId1(Id id1) {
            this.id1 = id1;
        }

        public void setId2(Id id2) {
            this.id2 = id2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPkNamesCount() != other.getPkNamesCount()) {
                return false;
            }
            if (this.getNamesCount() != other.getNamesCount()) {
                return false;
            }
            if (!Arrays.deepEquals(this.getPkTypes(), other.getPkTypes())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getTypes(), other.getTypes())) {
                return false;
            }
            Id this$id1 = this.getId1();
            Id other$id1 = other.getId1();
            if (this$id1 == null ? other$id1 != null : !((Object)this$id1).equals(other$id1)) {
                return false;
            }
            Id this$id2 = this.getId2();
            Id other$id2 = other.getId2();
            return !(this$id2 == null ? other$id2 != null : !((Object)this$id2).equals(other$id2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPkNamesCount();
            result = result * 59 + this.getNamesCount();
            result = result * 59 + Arrays.deepHashCode(this.getPkTypes());
            result = result * 59 + Arrays.deepHashCode(this.getTypes());
            Id $id1 = this.getId1();
            result = result * 59 + ($id1 == null ? 43 : ((Object)$id1).hashCode());
            Id $id2 = this.getId2();
            result = result * 59 + ($id2 == null ? 43 : ((Object)$id2).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractTableDiffer.Context(pkTypes=" + Arrays.deepToString(this.getPkTypes()) + ", types=" + Arrays.deepToString(this.getTypes()) + ", pkNamesCount=" + this.getPkNamesCount() + ", namesCount=" + this.getNamesCount() + ", id1=" + this.getId1() + ", id2=" + this.getId2() + ")";
        }
    }
}

