/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.Category;
import org.opoo.press.Post;
import org.opoo.press.Site;
import org.opoo.press.Tag;
import org.opoo.press.impl.AbstractBase;
import org.opoo.press.impl.CategoryImpl;
import org.opoo.press.impl.SiteImpl;
import org.opoo.press.impl.TagImpl;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;

public class PostImpl
extends AbstractBase
implements Post,
Comparable<Post> {
    public static final String DEFAUL_EXCERPT_SEPARATOR = "<!--more-->";
    public static Pattern FILENAME_PATTERN = Pattern.compile("[1-9][0-9]{3}[-][0-1][0-9][-][0-3][0-9][-](.*)");
    private List<String> stringCategories;
    private List<String> stringTags;
    private List<Category> categories = new ArrayList<Category>();
    private List<Tag> tags = new ArrayList<Tag>();
    private String id;
    private boolean published = true;
    private String title;
    private String excerpt;
    private boolean excerpted;
    private boolean isExcerptExtracted = false;
    private List<Post> relatedPosts;
    private Post next;
    private Post previous;

    PostImpl(SiteImpl site, Source source) {
        super(site, source);
        this.init();
    }

    private void init() {
        if (this.getDate() == null || this.getDateFormatted() == null) {
            throw new IllegalArgumentException("Date is required in post yaml front-matter header: " + this.getSource().getSourceEntry().getFile());
        }
        Map<String, Object> frontMatter = this.getSource().getMeta();
        this.title = (String)frontMatter.get("title");
        this.stringCategories = this.getStringList(frontMatter, "categories", "category");
        this.initCategories(this.stringCategories);
        this.stringTags = this.getStringList(frontMatter, "tags", "tag");
        this.initTags(this.stringTags);
        String url = (String)frontMatter.get("url");
        if (url == null) {
            String permalinkStyle = this.getPossiblePermalink();
            SourceEntry sourceEntry = this.getSource().getSourceEntry();
            url = PostImpl.buildPostUrl(this.getDate(), sourceEntry.getPath(), sourceEntry.getName(), permalinkStyle);
        }
        this.setUrl(url);
        this.id = url;
        Boolean bool = (Boolean)frontMatter.get("published");
        this.published = bool == null || bool != false;
        this.excerpt = (String)frontMatter.get("excerpt");
        if (StringUtils.isNotBlank((String)this.excerpt)) {
            this.excerpted = true;
        } else {
            this.extractExcerpt(this.getContent());
            this.isExcerptExtracted = true;
        }
    }

    private void initCategories(List<String> stringCategories) {
        if (stringCategories == null || stringCategories.isEmpty()) {
            return;
        }
        Site site = this.getSite();
        for (String stringCategory : stringCategories) {
            Category category = site.getCategory(stringCategory);
            if (category == null) {
                String nicename = site.toNicename(stringCategory);
                category = new CategoryImpl(nicename, stringCategory, site);
                site.getCategories().add(category);
            }
            category.getPosts().add(this);
            this.categories.add(category);
        }
    }

    private void initTags(List<String> stringTags) {
        if (stringTags == null || stringTags.isEmpty()) {
            return;
        }
        Site site = this.getSite();
        for (String stringTag : stringTags) {
            Tag tag = site.getTag(stringTag);
            if (tag == null) {
                String slug = site.toSlug(stringTag);
                tag = new TagImpl(slug, stringTag, site);
                site.getTags().add(tag);
            }
            tag.getPosts().add(this);
            this.tags.add(tag);
        }
    }

    private void extractExcerpt(String content) {
        int index;
        String excerptSeparator = (String)this.getSite().getConfig().get("excerpt_separator");
        if (excerptSeparator == null) {
            excerptSeparator = DEFAUL_EXCERPT_SEPARATOR;
        }
        if ((index = content.indexOf(excerptSeparator)) != -1) {
            this.excerpted = true;
            this.excerpt = content.substring(0, index);
        } else {
            this.excerpted = false;
            this.excerpt = content;
        }
    }

    private List<String> getStringList(Map<String, Object> frontMatter, String listName, String name) {
        String str;
        ArrayList<String> list = (ArrayList<String>)frontMatter.get(listName);
        if ((list == null || list.isEmpty()) && (str = (String)frontMatter.get(name)) != null) {
            list = new ArrayList<String>();
            list.add(str);
        }
        return list;
    }

    @Override
    protected void convert() {
        super.convert();
        if (this.isExcerptExtracted) {
            this.excerpt = this.getConverter().convert(this.excerpt);
        }
    }

    public List<String> getStringCategories() {
        return this.stringCategories;
    }

    public List<String> getStringTags() {
        return this.stringTags;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getExcerpt() {
        return this.excerpt;
    }

    @Override
    public boolean isExcerpted() {
        return this.excerpted;
    }

    public boolean isPublished() {
        return this.published;
    }

    @Override
    public Post getNext() {
        return this.next;
    }

    @Override
    public void setNext(Post next) {
        this.next = next;
    }

    @Override
    public void setPrevious(Post previous) {
        this.previous = previous;
    }

    @Override
    public Post getPrevious() {
        return this.previous;
    }

    public List<Post> getRelatedPosts() {
        return this.relatedPosts;
    }

    @Override
    public int compareTo(Post o) {
        return this.getDate().compareTo(o.getDate());
    }

    @Override
    public void render(Map<String, Object> rootMap) {
        super.render(rootMap);
        this.renderExcerpt(rootMap);
    }

    @Override
    protected void mergeRootMap(Map<String, Object> rootMap) {
        super.mergeRootMap(rootMap);
        rootMap.put("page", this);
        this.set("related_posts", this.findRelatedPost());
    }

    private List<Post> findRelatedPost() {
        int n;
        Number num = (Number)this.getSite().getConfig().get("related_posts");
        if (num == null) {
            num = 5;
        }
        if ((n = num.intValue()) == 0) {
            return null;
        }
        if (this.categories.isEmpty() || this.tags.isEmpty()) {
            return null;
        }
        ArrayList<Post> allRelatedPosts = new ArrayList<Post>();
        for (Category category : this.categories) {
            this.mergeRelatedPosts(allRelatedPosts, category.getPosts());
        }
        for (Tag tag : this.tags) {
            this.mergeRelatedPosts(allRelatedPosts, tag.getPosts());
        }
        if (allRelatedPosts.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(allRelatedPosts);
        Collections.reverse(allRelatedPosts);
        if (n > allRelatedPosts.size()) {
            n = allRelatedPosts.size();
        }
        return allRelatedPosts.subList(0, n);
    }

    private void mergeRelatedPosts(List<Post> allRelatedPosts, List<Post> posts) {
        for (Post post : posts) {
            if (post.equals(this) || allRelatedPosts.contains(post)) continue;
            allRelatedPosts.add(post);
        }
    }

    private void renderExcerpt(Map<String, Object> rootMap) {
        boolean isExcerptRenderRequired = this.getRenderer().isRenderRequired(this.excerpt);
        if (isExcerptRenderRequired) {
            this.excerpt = this.getRenderer().renderContent(this.excerpt, rootMap);
        }
    }

    @Override
    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    private String getPossiblePermalink() {
        String link = this.getPermalink();
        if (StringUtils.isNotBlank((String)link)) {
            return link;
        }
        return this.getSite().getPermalink();
    }

    private static String buildPostUrl(Date date, String pathToFile, String fileName, String permalinkStyle) {
        String baseName;
        String name = baseName = FilenameUtils.getBaseName((String)fileName);
        if (FILENAME_PATTERN.matcher(baseName).matches()) {
            name = baseName.substring(11);
        }
        if (StringUtils.isBlank((String)permalinkStyle)) {
            return pathToFile + "/" + name + "/";
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        int monthnum = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)":title", (String)name);
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)":year", (String)(year + ""));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)":month", (String)StringUtils.leftPad((String)(monthnum + ""), (int)2, (char)'0'));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)":day", (String)StringUtils.leftPad((String)(day + ""), (int)2, (char)'0'));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)":hour", (String)StringUtils.leftPad((String)(hour + ""), (int)2, (char)'0'));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)":minute", (String)StringUtils.leftPad((String)(minute + ""), (int)2, (char)'0'));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)":second", (String)StringUtils.leftPad((String)(second + ""), (int)2, (char)'0'));
        return permalinkStyle;
    }
}

