/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opoo.press.Site;
import org.opoo.press.SiteManager;
import org.opoo.press.impl.SiteServiceImpl;
import org.opoo.press.importer.Importer;
import org.opoo.press.util.ClassUtils;
import org.opoo.util.ClassPathUtils;

public class SiteManagerImpl
extends SiteServiceImpl
implements SiteManager {
    private static final Log log = LogFactory.getLog(SiteManagerImpl.class);
    public static final String DEFAULT_NEW_POST_TEMPLATE = "new_post.ftl";
    public static final String DEFAULT_NEW_PAGE_TEMPLATE = "new_page.ftl";
    public static final String DEFAULT_SAMPLE_POST_TEMPLATE = "sample-post.ftl";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat NAME_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DEFAULT_POST_DIR = "'article/'yyyy/MM/";
    private static final String DEFAULT_PAGE_DIR = "";

    @Override
    public Site install(File siteDir, Locale locale, boolean createSamplePost) throws Exception {
        if (siteDir.exists()) {
            throw new Exception("Site already initialized - " + siteDir.getAbsolutePath());
        }
        siteDir.mkdirs();
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        ClassPathUtils.copyPath(threadLoader, "site", siteDir);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.updateConfigFile(siteDir, locale);
        Site site = this.createSite(siteDir);
        if (createSamplePost) {
            log.info((Object)"Creating sample post.");
            this.createSamplePost(site, locale);
        }
        return site;
    }

    private void updateConfigFile(File siteDir, Locale locale) {
        boolean isZH = "zh".equals(locale.getLanguage());
        if (isZH) {
            FileUtils.deleteQuietly((File)new File(siteDir, "config.yml"));
            File file = new File(siteDir, "config_zh_CN.yml");
            file.renameTo(new File(siteDir, "config.yml"));
        } else {
            FileUtils.deleteQuietly((File)new File(siteDir, "config_zh_CN.yml"));
        }
    }

    protected String buildPostFileName(Site site, String name, Date date) {
        return NAME_FORMAT.format(date) + "-" + name + ".markdown";
    }

    protected String buildPostFilePath(Site site, String name, Date date) {
        String newPostDir = (String)site.getConfig().get("new_post_dir");
        if (newPostDir == null) {
            newPostDir = DEFAULT_POST_DIR;
        }
        return new SimpleDateFormat(newPostDir).format(date);
    }

    protected File buildPostFile(Site site, String name, Date date) {
        String path = this.buildPostFilePath(site, name, date);
        String filename = this.buildPostFileName(site, name, date);
        return new File(site.getSource(), path + filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSamplePost(Site site, Locale locale) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date date = new Date();
        String dateString = DATE_FORMAT.format(date);
        map.put("date", dateString);
        File file = this.buildPostFile(site, "hello-world", date);
        FileOutputStream os = null;
        OutputStreamWriter out = null;
        try {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            os = new FileOutputStream(file);
            out = new OutputStreamWriter((OutputStream)os, "UTF-8");
            site.getRenderer().render(DEFAULT_SAMPLE_POST_TEMPLATE, map, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
        IOUtils.closeQuietly((OutputStream)os);
        log.info((Object)("Sample post created: " + file));
    }

    @Override
    public void clean(Site site) throws Exception {
        File destination = site.getDestination();
        File working = site.getWorking();
        log.info((Object)("Cleaning destination directory " + destination));
        FileUtils.deleteDirectory((File)destination);
        log.info((Object)("Cleaning working directory " + working));
        FileUtils.deleteDirectory((File)working);
    }

    @Override
    public File newPage(Site site, String title, String name) throws Exception {
        String newPageDir;
        if (StringUtils.isBlank((String)title)) {
            throw new IllegalArgumentException("Title is required.");
        }
        name = this.processName(site, title, name);
        String template = (String)site.getConfig().get("new_page_template");
        if (StringUtils.isBlank((String)template)) {
            template = DEFAULT_NEW_PAGE_TEMPLATE;
        }
        if ((newPageDir = (String)site.getConfig().get("new_page_dir")) == null) {
            newPageDir = DEFAULT_PAGE_DIR;
        }
        Date date = new Date();
        String filepath = newPageDir;
        String filename = name + ".markdown";
        return this.newFile(site, title, name, date, filepath, filename, template, false);
    }

    @Override
    public File newPost(Site site, String title, String name, boolean draft) throws Exception {
        if (StringUtils.isBlank((String)title)) {
            throw new IllegalArgumentException("Title is required.");
        }
        name = this.processName(site, title, name);
        String template = (String)site.getConfig().get("new_post_template");
        if (StringUtils.isBlank((String)template)) {
            template = DEFAULT_NEW_POST_TEMPLATE;
        }
        Date date = new Date();
        String filepath = this.buildPostFilePath(site, name, date);
        String filename = this.buildPostFileName(site, name, date);
        return this.newFile(site, title, name, date, filepath, filename, template, draft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File newFile(Site site, String title, String name, Date date, String filePath, String fileName, String template, boolean draft) throws IOException {
        log.info((Object)("title: " + title));
        log.info((Object)("name: " + name));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", title);
        map.put("name", name);
        map.put("date", DATE_FORMAT.format(date));
        map.put("filename", fileName);
        map.put("filepath", filePath);
        map.put("site", site);
        if (draft) {
            map.put("published", false);
        }
        File file = new File(site.getSource(), filePath + fileName);
        FileOutputStream os = null;
        OutputStreamWriter out = null;
        try {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            os = new FileOutputStream(file);
            out = new OutputStreamWriter((OutputStream)os, "UTF-8");
            site.getRenderer().render(template, map, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
        IOUtils.closeQuietly((OutputStream)os);
        log.info((Object)("Write to file " + file));
        return file;
    }

    protected String processName(Site site, String title, String name) {
        if (name == null) {
            log.info((Object)"Using title as post name.");
            name = title;
        } else {
            name = name.trim();
        }
        name = site.toSlug(name);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(Site site) {
        long start = System.currentTimeMillis();
        try {
            site.build();
        }
        catch (Exception e) {
            log.error((Object)"Generate site exception", (Throwable)e);
        }
        finally {
            long time = System.currentTimeMillis() - start;
            log.info((Object)("Generate time: " + time + "ms"));
        }
    }

    @Override
    public void doImport(Site site, String importer, Map<String, Object> params) throws Exception {
        String className;
        Map importers = (Map)site.getConfig().get("importers");
        Importer importerInstance = null;
        if (importers != null && (className = (String)importers.get(importer)) != null) {
            importerInstance = (Importer)ClassUtils.newInstance(className, site);
        }
        if (importerInstance == null) {
            throw new Exception("No valid importer: " + importer);
        }
        importerInstance.doImport(site, params);
    }
}

