/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press;

import java.util.List;
import java.util.Map;
import org.opoo.press.Page;
import org.opoo.press.Post;
import org.opoo.press.source.Source;

public class Pager {
    private List<Post> posts;
    private int totalPosts;
    private int totalPages;
    private int pageNumber;
    private int pageSize;
    private Page next;
    private Page previous;

    public Pager(int pageNumber, int totalPages, int totalPosts, int pageSize, List<Post> pagePosts) {
        this.pageNumber = pageNumber;
        this.totalPages = totalPages;
        this.totalPosts = totalPosts;
        this.pageSize = pageSize;
        this.posts = pagePosts;
    }

    public Page getNext() {
        return this.next;
    }

    public void setNext(Page next) {
        this.next = next;
    }

    public Page getPrevious() {
        return this.previous;
    }

    public void setPrevious(Page previous) {
        this.previous = previous;
    }

    public List<Post> getPosts() {
        return this.posts;
    }

    public int getTotalPosts() {
        return this.totalPosts;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public static boolean isPaginationEnabled(Map<String, Object> config, Page page) {
        Source source = page.getSource();
        String name = source.getSourceEntry().getName();
        boolean containsKey = config.containsKey("paginate");
        String content = page.getContent();
        return containsKey && "index.html".equals(name) && content.contains("paginator.");
    }

    public static int calculateTotalPages(int totalPosts, int pageSize) {
        int totalPages = (int)Math.ceil((double)totalPosts / (double)pageSize);
        return totalPages;
    }
}

