/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.filter;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opoo.press.Site;
import org.opoo.press.filter.SiteFilterAdapter;

public class FixUrlSiteFilter
extends SiteFilterAdapter {
    private static final Log log = LogFactory.getLog(FixUrlSiteFilter.class);

    @Override
    public void postWrite(Site site) {
        String root = site.getRoot();
        if (StringUtils.isNotBlank((String)root)) {
            String cssFile = "screen.css";
            File file = new File(site.getDestination(), "stylesheets/" + cssFile);
            try {
                String content = FileUtils.readFileToString((File)file);
                content = StringUtils.replace((String)content, (String)"'/images/", (String)("'" + root + "/images/"));
                content = StringUtils.replace((String)content, (String)"\"/images/", (String)("\"" + root + "/images/"));
                FileUtils.write((File)file, (CharSequence)content, (String)"UTF-8");
                log.debug((Object)("Fix file: " + file));
            }
            catch (IOException e) {
                log.error((Object)("Fix url in css file failed: " + file), (Throwable)e);
            }
        }
    }
}

