/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.generator;

import java.util.ArrayList;
import java.util.List;
import org.opoo.press.Generator;
import org.opoo.press.Page;
import org.opoo.press.Pager;
import org.opoo.press.Post;
import org.opoo.press.Site;
import org.opoo.press.impl.PageImpl;

public class PaginationGenerator
implements Generator {
    @Override
    public void generate(Site site) {
        List<Page> pages = site.getPages();
        ArrayList<Page> allNewPages = new ArrayList<Page>();
        for (Page page : pages) {
            if (!Pager.isPaginationEnabled(site.getConfig().toMap(), page)) continue;
            this.paginate(site, page, allNewPages);
        }
        if (!allNewPages.isEmpty()) {
            site.getPages().addAll(allNewPages);
        }
    }

    private void paginate(Site site, Page page, List<Page> allNewPages) {
        int i;
        List<Post> posts = site.getPosts();
        int pageSize = ((Number)site.getConfig().get("paginate")).intValue();
        int totalPosts = posts.size();
        int totalPages = Pager.calculateTotalPages(totalPosts, pageSize);
        Page[] pages = new Page[totalPages];
        Pager[] pagers = new Pager[totalPages];
        for (i = 0; i < totalPages; ++i) {
            int pageNumber = i + 1;
            int fromIndex = i * pageSize;
            int toIndex = fromIndex + pageSize;
            if (toIndex > totalPosts) {
                toIndex = totalPosts;
            }
            List<Post> pagePosts = posts.subList(fromIndex, toIndex);
            Pager pager = new Pager(pageNumber, totalPages, totalPosts, pageSize, pagePosts);
            if (pageNumber > 1) {
                PageImpl impl = new PageImpl(site, page.getSource(), pager);
                pages[i] = impl;
                allNewPages.add(impl);
            } else {
                page.setPager(pager);
                pages[i] = page;
            }
            pagers[i] = pager;
        }
        for (i = 0; i < totalPages; ++i) {
            if (i > 0) {
                pagers[i].setPrevious(pages[i - 1]);
            }
            if (i >= totalPages - 1) continue;
            pagers[i].setNext(pages[i + 1]);
        }
    }

    @Override
    public int getOrder() {
        return 100;
    }
}

