/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opoo.press.Site;
import org.opoo.press.StaticFile;
import org.opoo.press.source.SourceEntry;

public class StaticFileImpl
implements StaticFile {
    private static final Log log = LogFactory.getLog(StaticFileImpl.class);
    private Site site;
    private SourceEntry sourceEntry;

    public StaticFileImpl(Site site, SourceEntry sourceEntry) {
        this.site = site;
        this.sourceEntry = sourceEntry;
    }

    public Site getSite() {
        return this.site;
    }

    public void setSite(Site site) {
        this.site = site;
    }

    public SourceEntry getSourceEntry() {
        return this.sourceEntry;
    }

    public void setSourceEntry(SourceEntry sourceEntry) {
        this.sourceEntry = sourceEntry;
    }

    @Override
    public File getOutputFile(File dest) {
        String file = this.sourceEntry.getPath() + "/" + this.sourceEntry.getName();
        return new File(dest, file);
    }

    @Override
    public void write(File dest) {
        File target = this.getOutputFile(dest);
        if (target.exists() && target.lastModified() >= this.sourceEntry.getLastModified()) {
            log.debug((Object)"Target file is newer than source file, skip copying.");
            return;
        }
        try {
            File parentFile = target.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileUtils.copyFile((File)this.sourceEntry.getFile(), (File)target);
        }
        catch (IOException e) {
            log.error((Object)("Copying static file error: " + target), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

