/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.util;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opoo.press.CompassConfig;
import org.opoo.press.Site;
import org.opoo.press.SiteConfig;

public class StaleUtils {
    private static final Log log = LogFactory.getLog(StaleUtils.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static final String DEFAULT_CSS_FILE = "screen.css";

    public static boolean isCompassStale(CompassConfig compassConfig) {
        return StaleUtils.isCompassStale(compassConfig, DEFAULT_CSS_FILE);
    }

    public static boolean isCompassStale(CompassConfig compassConfig, String cssFile) {
        File dir = compassConfig.getCssDirectory();
        File css = new File(dir, cssFile);
        if (!css.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Css file not exists, need compile compass: " + css));
            }
            return true;
        }
        if (!css.isFile()) {
            throw new IllegalArgumentException("Output css file is directory: " + css);
        }
        long lastModified = css.lastModified();
        File configFile = compassConfig.getConfigFile();
        if (configFile.lastModified() > lastModified) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Compass config is newer than css file, need recompile compass.");
            }
            return true;
        }
        File sass = compassConfig.getSassDirectory();
        return StaleUtils.isNewer(sass, lastModified, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".scss");
            }
        });
    }

    public static boolean isSourceStale(Site site) {
        Site.BuildInfo buildInfo = site.getLastBuildInfo();
        if (buildInfo == null) {
            log.info((Object)"No last generate info, regenerate site.");
            return true;
        }
        boolean showDrafts = site.showDrafts();
        if (showDrafts != buildInfo.showDrafts()) {
            log.info((Object)String.format("Show drafts changed, last: %s, current: %s. regenerate site.", buildInfo.showDrafts(), showDrafts));
            return true;
        }
        long lastBuildTime = buildInfo.getBuildTime();
        if (lastBuildTime <= 0L) {
            log.info((Object)"No last generate time, regenerate site.");
            return true;
        }
        SiteConfig config = site.getConfig();
        File configFile = config.getConfigFile();
        if (configFile.lastModified() > lastBuildTime) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Config file has been changed after time '" + StaleUtils.format(lastBuildTime) + "', regenerate site."));
            }
            return true;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                char firstChar = name.charAt(0);
                if (firstChar == '.' || firstChar == '#') {
                    return false;
                }
                char lastChar = name.charAt(name.length() - 1);
                return lastChar != '~';
            }
        };
        File source = site.getSource();
        boolean newer = StaleUtils.isNewer(source, lastBuildTime, filter);
        if (newer) {
            log.info((Object)("Source file has been changed after time '" + StaleUtils.format(lastBuildTime) + "', regenerate site."));
            return true;
        }
        File templates = site.getTemplates();
        newer = StaleUtils.isNewer(templates, lastBuildTime, filter);
        if (newer) {
            log.info((Object)("Template file has been changed after time '" + StaleUtils.format(lastBuildTime) + "', regenerate site."));
            return true;
        }
        File assets = site.getAssets();
        if (assets != null && assets.exists() && (newer = StaleUtils.isNewer(assets, lastBuildTime, filter))) {
            log.info((Object)("Asset file has been changed after time '" + StaleUtils.format(lastBuildTime) + "', regenerate site."));
            return true;
        }
        return false;
    }

    public static boolean isNewer(File dir, long compareTime, FilenameFilter filter) {
        File[] listFiles;
        for (File file : listFiles = dir.listFiles(filter)) {
            if (file.isHidden()) {
                log.debug((Object)("Skip check hidden file: " + file));
                continue;
            }
            if (file.isFile()) {
                if (file.lastModified() <= compareTime) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("File '%s' is newer than '%s'", file, StaleUtils.format(compareTime)));
                }
                return true;
            }
            if (!file.isDirectory() || !StaleUtils.isNewer(file, compareTime, filter)) continue;
            return true;
        }
        return false;
    }

    public static String format(long millis) {
        return SDF.format(new Date(millis));
    }
}

