/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChainingClassLoader
extends URLClassLoader {
    private static final Log log = LogFactory.getLog(ChainingClassLoader.class);
    private final ClassLoader parent;
    private final Collection<ClassLoader> loaders;
    private static final URL[] NULL_URL_ARRAY = new URL[0];
    private static Map<String, Object> classLookupCache = new HashMap<String, Object>();

    public ChainingClassLoader(ClassLoader parent, Collection<ClassLoader> loaders) {
        super(NULL_URL_ARRAY, parent);
        this.parent = parent;
        this.loaders = loaders;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        Object cls = classLookupCache.get(string);
        if (cls != null) {
            if (cls instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cls;
            }
            return (Class)cls;
        }
        ClassNotFoundException ex = null;
        Class<?> clazz = null;
        try {
            clazz = this.parent.loadClass(string);
        }
        catch (ClassNotFoundException e) {
            ex = e;
        }
        if (clazz == null) {
            for (ClassLoader l : this.loaders) {
                try {
                    clazz = l.loadClass(string);
                    break;
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        if (clazz == null) {
            classLookupCache.put(string, ex);
            throw ex;
        }
        classLookupCache.put(string, clazz);
        return clazz;
    }

    @Override
    public URL getResource(String string) {
        URL url;
        block1: {
            ClassLoader l;
            url = this.parent.getResource(string);
            if (url != null) break block1;
            Iterator<ClassLoader> i$ = this.loaders.iterator();
            while (i$.hasNext() && (url = (l = i$.next()).getResource(string)) == null) {
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration<URL> enumeration;
        block1: {
            ClassLoader l;
            enumeration = this.parent.getResources(string);
            if (enumeration != null && enumeration.hasMoreElements()) break block1;
            Iterator<ClassLoader> i$ = this.loaders.iterator();
            while (i$.hasNext() && ((enumeration = (l = i$.next()).getResources(string)) == null || !enumeration.hasMoreElements())) {
            }
        }
        return enumeration;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream stream;
        block1: {
            ClassLoader l;
            stream = this.parent.getResourceAsStream(string);
            if (stream != null) break block1;
            Iterator<ClassLoader> i$ = this.loaders.iterator();
            while (i$.hasNext() && (stream = (l = i$.next()).getResourceAsStream(string)) == null) {
            }
        }
        return stream;
    }

    @Override
    public URL[] getURLs() {
        if (this.parent instanceof URLClassLoader) {
            try {
                URL[] resource = ((URLClassLoader)this.parent).getURLs();
                if (resource != null) {
                    return resource;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return super.getURLs();
    }

    @Override
    public URL findResource(String string) {
        if (this.parent instanceof URLClassLoader) {
            try {
                URL resource = ((URLClassLoader)this.parent).findResource(string);
                if (resource != null) {
                    return resource;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return super.findResource(string);
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        if (this.parent instanceof URLClassLoader) {
            try {
                Enumeration<URL> resource = ((URLClassLoader)this.parent).findResources(string);
                if (resource != null) {
                    return resource;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return super.findResources(string);
    }

    public static void clearCache() {
        classLookupCache.clear();
    }

    public ClassLoader getWrappedClassLoader() {
        return this.parent;
    }
}

