/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClassPathUtils {
    private static final Log log = LogFactory.getLog(ClassPathUtils.class);
    private static final boolean IS_DEBUG_ENABLED = log.isDebugEnabled();
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    public static final String JAR_URL_SEPARATOR = "!/";

    private ClassPathUtils() {
    }

    public static void copyPath(ClassLoader loader, String classPathSource, File destination) throws Exception {
        ClassPathUtils.copyPath(loader, classPathSource, destination, true);
    }

    public static void copyPath(ClassLoader loader, String classPathSource, File destination, boolean overwrite) throws Exception {
        boolean b;
        if (classPathSource == null || destination == null) {
            return;
        }
        URL url = loader.getResource(classPathSource);
        if (IS_DEBUG_ENABLED) {
            log.debug((Object)("Copy path from '" + url + "' to '" + destination + "'"));
        }
        if (b = ClassPathUtils.isJarURL(url)) {
            URL jarFileURL = ClassPathUtils.extractJarFileURL(url);
            ClassPathUtils.copyJarPath(jarFileURL, classPathSource, destination, overwrite);
        } else {
            ClassPathUtils.copyFilePath(url, destination, overwrite);
        }
    }

    protected static void copyJarPath(URL jarFileURL, String sourcePath, File destination, boolean overwrite) throws Exception {
        String root;
        if (!sourcePath.endsWith("/")) {
            sourcePath = sourcePath + "/";
        }
        if (!(root = jarFileURL.toString() + JAR_URL_SEPARATOR).startsWith("jar:")) {
            root = "jar:" + root;
        }
        JarFile jarFile = new JarFile(new File(jarFileURL.toURI()));
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String relativePath;
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            if (!name.startsWith(sourcePath) || (relativePath = name.substring(sourcePath.length())) == null || relativePath.length() <= 0) continue;
            File tmp = new File(destination, relativePath);
            if (!overwrite && tmp.exists()) continue;
            if (jarEntry.isDirectory()) {
                tmp.mkdirs();
                if (!IS_DEBUG_ENABLED) continue;
                log.debug((Object)("Create directory\uff1a" + tmp));
                continue;
            }
            File parent = tmp.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            URL u = new URL(root + name);
            FileUtils.copyURLToFile((URL)u, (File)tmp);
            if (!IS_DEBUG_ENABLED) continue;
            log.debug((Object)("Copyed file '" + u + "' to '" + tmp + "'."));
        }
        try {
            jarFile.close();
        }
        catch (Exception ie) {
            // empty catch block
        }
    }

    protected static void copyFilePath(URL sourceDirectoryURL, File destination, boolean overwrite) throws Exception {
        File[] nodes;
        URI classPathNode = sourceDirectoryURL.toURI();
        File f = new File(classPathNode);
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if ((nodes = f.listFiles()) == null || nodes.length == 0) {
            return;
        }
        for (File node : nodes) {
            if (node.isDirectory()) {
                FileUtils.copyDirectory((File)node, (File)new File(destination, node.getName()));
                continue;
            }
            FileUtils.copyFile((File)node, (File)new File(destination, node.getName()));
        }
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().contains(JAR_URL_SEPARATOR);
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                return new URL(FILE_URL_PREFIX + jarFile);
            }
        }
        return jarUrl;
    }
}

