/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.converter;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.opoo.press.Converter;
import org.opoo.press.Initializable;
import org.opoo.press.Site;
import org.opoo.press.SiteConfig;
import org.opoo.press.highlighter.Highlighter;
import org.opoo.press.source.Source;
import org.opoo.press.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtmarkMarkdownConverter
implements Converter,
Initializable {
    private static final Logger log = LoggerFactory.getLogger(TxtmarkMarkdownConverter.class);
    private Configuration config;
    private Highlighter highlighter;

    @Override
    public void initialize(Site site) {
        SiteConfig map = site.getConfig();
        String highlighterClassName = (String)map.get("highlighter");
        if (highlighterClassName == null) {
            log.warn("This converter might be need a Highlighter.");
        } else {
            this.highlighter = (Highlighter)ClassUtils.newInstance(highlighterClassName, site);
            this.config = Configuration.builder().setCodeBlockEmitter((BlockEmitter)new BlockEmitterImpl(this.highlighter)).forceExtentedProfile().build();
        }
    }

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    public boolean matches(Source src) {
        String name = src.getSourceEntry().getName().toLowerCase();
        if (FilenameUtils.isExtension((String)name, (String[])new String[]{"markdown", "md"})) {
            return true;
        }
        return "post".equals(src.getMeta().get("layout")) && FilenameUtils.isExtension((String)name, (String)"txt");
    }

    @Override
    public String convert(String content) {
        if (this.config != null) {
            return Processor.process((String)content, (Configuration)this.config);
        }
        return Processor.process((String)content);
    }

    @Override
    public String getOutputFileExtension(Source src) {
        return ".html";
    }

    private static class BlockEmitterImpl
    implements BlockEmitter {
        private Highlighter highlighter;

        public BlockEmitterImpl(Highlighter highlighter) {
            this.highlighter = highlighter;
        }

        public void emitBlock(StringBuilder out, List<String> lines, String meta) {
            this.highlighter.highlight(out, lines, meta);
        }
    }
}

