/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opoo.press.Category;
import org.opoo.press.Initializable;
import org.opoo.press.Post;
import org.opoo.press.RelatedPostsFinder;
import org.opoo.press.Site;
import org.opoo.press.Tag;

public class SimpleRelatedPostsFinder
implements RelatedPostsFinder,
Initializable {
    private int size = 5;

    public SimpleRelatedPostsFinder(Site site) {
        this.initialize(site);
    }

    public SimpleRelatedPostsFinder() {
    }

    @Override
    public void initialize(Site site) {
        Number num = (Number)site.getConfig().get("related_posts");
        if (num != null) {
            this.size = num.intValue();
        }
    }

    @Override
    public List<Post> findRelatedPosts(Post post) {
        return this.findRelatedPosts(post, this.size);
    }

    @Override
    public List<Post> findRelatedPosts(Post post, int size) {
        if (size <= 0) {
            return null;
        }
        List<Category> categories = post.getCategories();
        List<Tag> tags = post.getTags();
        if (categories.isEmpty() || tags.isEmpty()) {
            return null;
        }
        ArrayList<Post> allRelatedPosts = new ArrayList<Post>();
        for (Category category : categories) {
            this.mergeRelatedPosts(allRelatedPosts, post, category.getPosts());
        }
        for (Tag tag : tags) {
            this.mergeRelatedPosts(allRelatedPosts, post, tag.getPosts());
        }
        if (allRelatedPosts.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(allRelatedPosts);
        Collections.reverse(allRelatedPosts);
        if (size > allRelatedPosts.size()) {
            size = allRelatedPosts.size();
        }
        return allRelatedPosts.subList(0, size);
    }

    private void mergeRelatedPosts(List<Post> allRelatedPosts, Post thisPost, List<Post> posts) {
        for (Post post : posts) {
            if (post.equals(thisPost) || allRelatedPosts.contains(post)) continue;
            allRelatedPosts.add(post);
        }
    }
}

