/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.Site;
import org.opoo.press.SiteManager;
import org.opoo.press.impl.SiteServiceImpl;
import org.opoo.press.importer.Importer;
import org.opoo.press.util.ClassUtils;
import org.opoo.press.util.LinkUtils;
import org.opoo.util.ClassPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteManagerImpl
extends SiteServiceImpl
implements SiteManager {
    private static final Logger log = LoggerFactory.getLogger(SiteManagerImpl.class);
    public static final String NEW_POST_TEMPLATE = "new_post.ftl";
    public static final String NEW_PAGE_TEMPLATE = "new_page.ftl";
    public static final String DEFAULT_NEW_POST_FILE = "article/${year}-${month}-${day}-${name}.${format}";
    public static final String DEFAULT_NEW_PAGE_FILE = "${name}.${format}";
    public static final String NEW_POST_FILE_KEY = "new_post";
    public static final String NEW_PAGE_FILE_KEY = "new_page";
    public static final String SAMPLE_POST_TEMPLATE = "sample-post.ftl";
    public static final String SAMPLE_POST_NAME = "hello-world";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    @Override
    public Site install(File siteDir, Locale locale, boolean createSamplePost) throws Exception {
        if (siteDir.exists()) {
            throw new Exception("Site already initialized - " + siteDir.getAbsolutePath());
        }
        siteDir.mkdirs();
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        ClassPathUtils.copyPath(threadLoader, "site", siteDir);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.updateConfigFile(siteDir, locale);
        Site site = this.createSite(siteDir);
        if (createSamplePost) {
            log.info("Creating sample post.");
            this.createSamplePost(site, locale);
        }
        return site;
    }

    private void updateConfigFile(File siteDir, Locale locale) {
        boolean isZH = "zh".equals(locale.getLanguage());
        if (isZH) {
            FileUtils.deleteQuietly((File)new File(siteDir, "config.yml"));
            File file = new File(siteDir, "config_zh_CN.yml");
            file.renameTo(new File(siteDir, "config.yml"));
        } else {
            FileUtils.deleteQuietly((File)new File(siteDir, "config_zh_CN.yml"));
        }
    }

    private void createSamplePost(Site site, Locale locale) throws IOException {
        this.renderFile(site, "", SAMPLE_POST_NAME, this.getNewPostFileStyle(site), SAMPLE_POST_TEMPLATE, false, "markdown");
    }

    @Override
    public void clean(Site site) throws Exception {
        File destination = site.getDestination();
        File working = site.getWorking();
        log.info("Cleaning destination directory " + destination);
        FileUtils.deleteDirectory((File)destination);
        log.info("Cleaning working directory " + working);
        FileUtils.deleteDirectory((File)working);
    }

    @Override
    public File newPage(Site site, String title, String name) throws Exception {
        return this.newPage(site, title, name, null);
    }

    @Override
    public File newPage(Site site, String title, String name, String format) throws Exception {
        if (StringUtils.isBlank((String)title)) {
            throw new IllegalArgumentException("Title is required.");
        }
        String newPageFile = (String)site.getConfig().get(NEW_PAGE_FILE_KEY);
        if (StringUtils.isBlank((String)newPageFile)) {
            newPageFile = DEFAULT_NEW_PAGE_FILE;
        }
        return this.renderFile(site, title, name, newPageFile, NEW_PAGE_TEMPLATE, false, format);
    }

    private String getNewPostFileStyle(Site site) {
        String newPostFile = (String)site.getConfig().get(NEW_POST_FILE_KEY);
        if (StringUtils.isBlank((String)newPostFile)) {
            newPostFile = DEFAULT_NEW_POST_FILE;
        }
        return newPostFile;
    }

    @Override
    public File newPost(Site site, String title, String name, boolean draft) throws Exception {
        return this.newPost(site, title, name, draft, null);
    }

    @Override
    public File newPost(Site site, String title, String name, boolean draft, String format) throws Exception {
        if (StringUtils.isBlank((String)title)) {
            throw new IllegalArgumentException("Title is required.");
        }
        return this.renderFile(site, title, name, this.getNewPostFileStyle(site), NEW_POST_TEMPLATE, draft, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File renderFile(Site site, String title, String name, String newFileStyle, String newFileTemplate, boolean isDraft, String format) throws IOException {
        name = this.processName(site, title, name);
        if (format == null) {
            format = "markdown";
        }
        Date date = new Date();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", title);
        map.put("name", name);
        map.put("format", format);
        map.put("date", DATE_FORMAT.format(date));
        LinkUtils.addDateParams(map, date);
        String filename = site.getRenderer().renderContent(newFileStyle, map);
        File file = new File(site.getSource(), filename);
        map.put("site", site);
        map.put("file", file);
        map.put("published", !isDraft);
        FileOutputStream os = null;
        OutputStreamWriter out = null;
        try {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            os = new FileOutputStream(file);
            out = new OutputStreamWriter((OutputStream)os, "UTF-8");
            site.getRenderer().render(newFileTemplate, map, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
        IOUtils.closeQuietly((OutputStream)os);
        log.info("Write to file " + file);
        return file;
    }

    private String processName(Site site, String title, String name) {
        if (name == null) {
            log.info("Using title as post name.");
            name = title;
        } else {
            name = name.trim();
        }
        name = site.toSlug(name);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(Site site) {
        long start = System.currentTimeMillis();
        try {
            site.build();
        }
        catch (Exception e) {
            log.error("Generate site exception", (Throwable)e);
        }
        finally {
            long time = System.currentTimeMillis() - start;
            log.info("Generate time: " + time + "ms");
        }
    }

    @Override
    public void doImport(Site site, String importer, Map<String, Object> params) throws Exception {
        String className;
        Map importers = (Map)site.getConfig().get("importers");
        Importer importerInstance = null;
        if (importers != null && (className = (String)importers.get(importer)) != null) {
            importerInstance = (Importer)ClassUtils.newInstance(className, site);
        }
        if (importerInstance == null) {
            throw new Exception("No valid importer: " + importer);
        }
        importerInstance.doImport(site, params);
    }
}

