/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.util;

import java.util.Map;

public abstract class MapUtils {
    public static <K, V> void put(Map<K, V> map, K key, V value) {
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    public static <K, V> boolean get(Map<K, V> map, K key, boolean defaultValue) {
        V object = map.get(key);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return "true".equalsIgnoreCase(object.toString());
    }

    public static <K, V> V get(Map<K, V> map, K key, V defaultValue) {
        if (!map.containsKey(key)) {
            return defaultValue;
        }
        return map.get(key);
    }

    public static <K, V> K getKeyByValue(Map<K, V> map, V value) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        for (Map.Entry<K, V> en : map.entrySet()) {
            if (!value.equals(en.getValue())) continue;
            return en.getKey();
        }
        return null;
    }
}

