/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opoo.press.Generator;
import org.opoo.press.Page;
import org.opoo.press.Pager;
import org.opoo.press.Post;
import org.opoo.press.Site;
import org.opoo.press.impl.PageImpl;
import org.opoo.press.source.SourceEntry;

public class PaginationGenerator
implements Generator {
    @Override
    public void generate(Site site) {
        List<Page> pages = site.getPages();
        Map<String, Object> map = site.getConfig().toMap();
        ArrayList<Page> allNewPages = new ArrayList<Page>();
        for (Page page : pages) {
            if (!PaginationGenerator.isPaginationEnabled(map, page)) continue;
            List<Page> list = PaginationGenerator.paginate(site, page, site.getPosts());
            allNewPages.addAll(list);
        }
        if (!allNewPages.isEmpty()) {
            site.getPages().addAll(allNewPages);
        }
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public static boolean isPaginationEnabled(Site site, Page page) {
        return PaginationGenerator.isPaginationEnabled(site.getConfig().toMap(), page);
    }

    public static boolean isPaginationEnabled(Map<String, Object> config, Page page) {
        SourceEntry entry = page.getSource().getSourceEntry();
        String name = entry.getName();
        String path = entry.getPath();
        return (config.containsKey("paginate") && "".equals(path) && "index.html".equals(name) || page.get("paginate") != null) && page.getContent().contains("paginator.");
    }

    public static int calculateTotalPages(int totalPosts, int pageSize) {
        int totalPages = (int)Math.ceil((double)totalPosts / (double)pageSize);
        return totalPages;
    }

    public static List<Page> paginate(Site site, Page page, List<Post> posts) {
        Number number = (Number)page.get("paginate");
        if (number == null) {
            number = (Number)site.getConfig().get("paginate");
        }
        if (number == null) {
            throw new IllegalArgumentException("No page size variable specified.");
        }
        int pageSize = number.intValue();
        return PaginationGenerator.paginate(site, page, posts, pageSize);
    }

    public static List<Page> paginate(Site site, Page page, List<Post> posts, int pageSize) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int totalPosts = posts.size();
        int totalPages = PaginationGenerator.calculateTotalPages(totalPosts, pageSize);
        Page[] pages = new Page[totalPages];
        Pager[] pagers = new Pager[totalPages];
        for (int i = 0; i < totalPages; ++i) {
            int pageNumber = i + 1;
            int fromIndex = i * pageSize;
            int toIndex = fromIndex + pageSize;
            if (toIndex > totalPosts) {
                toIndex = totalPosts;
            }
            List<Post> pagePosts = posts.subList(fromIndex, toIndex);
            Pager pager = new Pager(pageNumber, totalPages, totalPosts, pageSize, pagePosts);
            if (pageNumber > 1) {
                PageImpl impl = new PageImpl(site, page.getSource(), pager);
                pages[i] = impl;
                newPages.add(impl);
            } else {
                page.setPager(pager);
                pages[i] = page;
            }
            pagers[i] = pager;
        }
        int maxIndex = totalPages - 1;
        for (int i = 0; i < totalPages; ++i) {
            if (i > 0) {
                pagers[i].setPrevious(pages[i - 1]);
            }
            if (i >= maxIndex) continue;
            pagers[i].setNext(pages[i + 1]);
        }
        return newPages;
    }
}

