/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opoo.press.Initializable;
import org.opoo.press.Post;
import org.opoo.press.PostsHolder;
import org.opoo.press.RelatedPostsFinder;
import org.opoo.press.Site;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosineSimilarityRelatedPostsFinder
implements RelatedPostsFinder,
Initializable {
    private static final Logger log = LoggerFactory.getLogger(CosineSimilarityRelatedPostsFinder.class);
    private int size = 5;
    private double categoriesFactor = 1.0;
    private double tagsFactor = 1.0;

    @Override
    public List<Post> findRelatedPosts(Post post) {
        return this.findRelatedPosts(post, this.size);
    }

    @Override
    public List<Post> findRelatedPosts(Post post, int size) {
        double score;
        if (size <= 0 || post.getCategories().isEmpty() && post.getTags().isEmpty()) {
            return null;
        }
        Map<Post, Integer> categoriesCountMap = CosineSimilarityRelatedPostsFinder.calculatePostsCount(post, post.getCategories());
        Map<Post, Integer> tagsCountMap = CosineSimilarityRelatedPostsFinder.calculatePostsCount(post, post.getTags());
        HashMap<Post, Double> scoreMap = new HashMap<Post, Double>();
        for (Map.Entry<Post, Integer> en : categoriesCountMap.entrySet()) {
            score = CosineSimilarityRelatedPostsFinder.calculate(en.getValue(), post.getCategories().size(), en.getKey().getCategories().size());
            scoreMap.put(en.getKey(), score *= this.categoriesFactor);
        }
        for (Map.Entry<Post, Integer> en : tagsCountMap.entrySet()) {
            score = CosineSimilarityRelatedPostsFinder.calculate(en.getValue(), post.getTags().size(), en.getKey().getTags().size());
            Double val = (Double)scoreMap.get(en.getKey());
            if (val == null) {
                val = 0.0;
            }
            score = score * this.tagsFactor + val;
            scoreMap.put(en.getKey(), score);
        }
        final long time = post.getDate().getTime();
        ArrayList list = new ArrayList(scoreMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Post, Double>>(){

            @Override
            public int compare(Map.Entry<Post, Double> o1, Map.Entry<Post, Double> o2) {
                double x = o1.getValue() - o2.getValue();
                int compare = (int)(x * 1.0E8);
                if (x == 0.0) {
                    long b;
                    long a = Math.abs(o1.getKey().getDate().getTime() - time);
                    return a < (b = Math.abs(o2.getKey().getDate().getTime() - time)) ? 1 : (a == b ? 0 : -1);
                }
                return compare;
            }
        });
        Collections.reverse(list);
        if (size > list.size()) {
            size = list.size();
        }
        List subList = list.subList(0, size);
        ArrayList<Post> result = new ArrayList<Post>();
        for (Map.Entry en : subList) {
            result.add((Post)en.getKey());
        }
        return result;
    }

    static Map<Post, Integer> calculatePostsCount(Post post, List<? extends PostsHolder> holders) {
        HashMap<Post, Integer> countMap = new HashMap<Post, Integer>();
        for (PostsHolder postsHolder : holders) {
            List<Post> posts = postsHolder.getPosts();
            for (Post p : posts) {
                if (p.equals(post)) continue;
                Integer count = (Integer)countMap.get(p);
                if (count == null) {
                    countMap.put(p, 1);
                    continue;
                }
                countMap.put(p, count + 1);
            }
        }
        return countMap;
    }

    static double calculate(int n, int a, int b) {
        double x = (double)n * 1.0 / (Math.sqrt(a) * Math.sqrt(b));
        return x;
    }

    @Override
    public void initialize(Site site) {
        Number num = (Number)site.getConfig().get("related_posts");
        if (num != null) {
            this.size = num.intValue();
            log.debug("Set related posts size: {}", (Object)this.size);
        }
        String prefix = CosineSimilarityRelatedPostsFinder.class.getName();
        String categoriesFactorKey = prefix + ".categories.factor";
        String tagsFactorKey = prefix + ".tags.factor";
        Number num1 = (Number)site.getConfig().get(categoriesFactorKey);
        Number num2 = (Number)site.getConfig().get(tagsFactorKey);
        if (num1 != null) {
            this.categoriesFactor = num1.doubleValue();
            log.debug("Set {}: {}", (Object)categoriesFactorKey, (Object)this.categoriesFactor);
        }
        if (num2 != null) {
            this.tagsFactor = num2.doubleValue();
            log.debug("Set {}: {}", (Object)tagsFactorKey, (Object)this.tagsFactor);
        }
    }
}

