/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.SiteConfig;
import org.opoo.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SiteConfigImpl
extends LinkedHashMap<String, Object>
implements SiteConfig {
    private static final Logger log = LoggerFactory.getLogger(SiteConfigImpl.class);
    private static final long serialVersionUID = 6443434786872527839L;
    private final Object lock = new Object();
    private final Map<String, Object> extraConfig;
    private final File configFile;
    private final File siteDir;
    private boolean loaded = false;
    private Yaml yaml;

    public SiteConfigImpl(File siteDir, Map<String, Object> extraConfig) {
        if (!(siteDir != null && siteDir.exists() && siteDir.isDirectory() && siteDir.canRead())) {
            throw new IllegalArgumentException("Site directory not valid.");
        }
        this.configFile = new File(siteDir, "config.yml");
        this.extraConfig = extraConfig;
        this.siteDir = siteDir;
    }

    public SiteConfigImpl(File siteDir) {
        this(siteDir, null);
    }

    void setYaml(Yaml yaml) {
        this.yaml = yaml;
    }

    private synchronized void load() {
        if (this.yaml == null) {
            this.yaml = new Yaml();
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.configFile);
            Map config = (Map)this.yaml.load((InputStream)stream);
            this.putAll(config);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalArgumentException("config file not found: " + this.configFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        if (this.extraConfig != null) {
            log.debug("Merge extra config to main config map.");
            this.putAll(this.extraConfig);
        }
        this.put("site", this.siteDir);
        this.fixRoot();
        this.loaded = true;
    }

    private void fixRoot() {
        String rootUrl = (String)super.get("root");
        if (rootUrl == null) {
            this.put("root", "");
            return;
        }
        if ((rootUrl = rootUrl.trim()).equals("/") || "".equals(rootUrl)) {
            this.put("root", "");
            return;
        }
        if (rootUrl.endsWith("/")) {
            rootUrl = StringUtils.removeEnd((String)rootUrl, (String)"/");
        }
        if (!rootUrl.startsWith("/")) {
            rootUrl = "/" + rootUrl;
        }
        this.put("root", rootUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        if (!this.loaded) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.loaded) {
                    this.load();
                    this.loaded = true;
                }
            }
        }
        return super.get(key);
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public Map<String, Object> getExtraConfig() {
        return this.extraConfig;
    }

    @Override
    public Object get(String name) {
        return this.get((Object)name);
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        return (T)MapUtils.get(this, name, defaultValue);
    }

    @Override
    public Map<String, Object> toMap() {
        return this;
    }

    @Override
    public void reload() {
        super.clear();
        this.loaded = false;
    }
}

