/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.util.ArrayList;
import java.util.List;
import org.opoo.press.Post;
import org.opoo.press.Site;
import org.opoo.press.Tag;
import org.opoo.util.URLUtils;

public class TagImpl
implements Tag {
    private String slug;
    private String name;
    private List<Post> posts = new ArrayList<Post>();
    private String url;

    public TagImpl(String slug, String name, Site site) {
        this.slug = slug;
        this.name = name;
        String tagDir = site.getConfig().get("tag_dir", "");
        this.url = tagDir + "/" + URLUtils.encodeURL(slug) + "/";
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isNameOrSlug(String nameOrSlug) {
        if (nameOrSlug.equals(this.getSlug())) {
            return true;
        }
        return nameOrSlug.equals(this.getName());
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public List<Post> getPosts() {
        return this.posts;
    }

    public int getPostSize() {
        return this.posts.size();
    }
}

