/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.plugin;

import java.util.List;
import org.opoo.press.Converter;
import org.opoo.press.Generator;
import org.opoo.press.Plugin;
import org.opoo.press.Registry;
import org.opoo.press.Site;
import org.opoo.press.SiteConfig;
import org.opoo.press.SiteFilter;
import org.opoo.press.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(DefaultPlugin.class);
    private static final boolean IS_DEBUG_ENABLED = log.isDebugEnabled();

    @Override
    public void initialize(Registry registry) {
        Site site = registry.getSite();
        SiteConfig config = site.getConfig();
        List converterNames = (List)config.get("converters");
        List generatorNames = (List)config.get("generators");
        List siteFilters = (List)config.get("siteFilters");
        if (converterNames != null && !converterNames.isEmpty()) {
            for (String converterName : converterNames) {
                Converter c = (Converter)ClassUtils.newInstance(converterName, site);
                registry.registerConverter(c);
                if (!IS_DEBUG_ENABLED) continue;
                log.debug("Register converter: " + converterName);
            }
        }
        if (generatorNames != null && !generatorNames.isEmpty()) {
            for (String generatorName : generatorNames) {
                Generator g = (Generator)ClassUtils.newInstance(generatorName, site);
                registry.registerGenerator(g);
                if (!IS_DEBUG_ENABLED) continue;
                log.debug("Register generator: " + generatorName);
            }
        }
        if (siteFilters != null && !siteFilters.isEmpty()) {
            for (String filterName : siteFilters) {
                SiteFilter f = (SiteFilter)ClassUtils.newInstance(filterName, site);
                registry.registerSiteFilter(f);
                if (!IS_DEBUG_ENABLED) continue;
                log.debug("Register site filter: " + filterName);
            }
        }
    }
}

