/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.slug;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.opoo.press.SlugHelper;
import org.opoo.press.slug.DefaultSlugHelper;

public class ChineseToPinyinSlugHelper
implements SlugHelper {
    private static HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();

    @Override
    public String toSlug(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        text = text.toLowerCase();
        text = text.replace(' ', '-');
        char[] chars = text.toLowerCase().toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean previousIsChinese = false;
        for (char c : chars) {
            String string;
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '/' || c == '.') {
                if (previousIsChinese) {
                    sb.append('-');
                }
                sb.append(c);
                previousIsChinese = false;
                continue;
            }
            if (!ChineseToPinyinSlugHelper.isChinese(c) || (string = ChineseToPinyinSlugHelper.toPinYin(c)) == null) continue;
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(string);
            previousIsChinese = true;
        }
        DefaultSlugHelper.trimDot(sb);
        return sb.toString();
    }

    public static String toPinYin(char c) {
        try {
            String[] strings = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat);
            if (strings != null && strings.length > 0) {
                return strings[0];
            }
            return null;
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    static {
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }
}

