/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opoo.press.Base;
import org.opoo.press.Converter;
import org.opoo.press.Renderer;
import org.opoo.press.Site;
import org.opoo.press.highlighter.Highlighter;
import org.opoo.press.impl.AbstractConvertible;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;
import org.opoo.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBase
extends AbstractConvertible
implements Base {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static DateFormat f1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static DateFormat f2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final Map<String, Object> data;
    private Source source;
    private Site site;
    private String content;
    private String url;
    private String path;
    private String layout;
    private String permalink;
    private Date date;
    private Date updated;
    private String dateFormatted;
    private String updatedFormatted;
    private String outputFileExtension;
    private Converter converter;

    AbstractBase(Site site, Source source) {
        this.source = source;
        this.site = site;
        this.data = new HashMap<String, Object>(source.getMeta());
        String title = (String)this.data.get("title");
        if (title != null) {
            this.log = LoggerFactory.getLogger((String)(this.getClass().getName() + "[" + title + "]"));
        }
        this.init();
    }

    @Override
    public void set(String name, Object value) {
        MapUtils.put(this.data, name, value);
    }

    @Override
    public Object get(String name) {
        return this.data.get(name);
    }

    private void init() {
        this.converter = this.site.getConverter(this.source);
        this.outputFileExtension = this.converter.getOutputFileExtension(this.source);
        this.content = this.source.getContent();
        this.layout = (String)this.source.getMeta().get("layout");
        this.permalink = (String)this.source.getMeta().get("permalink");
        this.path = (String)this.source.getMeta().get("path");
        if (this.path == null) {
            SourceEntry sourceEntry = this.source.getSourceEntry();
            this.path = sourceEntry.getPath() + "/" + sourceEntry.getName();
        }
        this.date = this.lookup(this.source.getMeta(), "date");
        this.updated = this.lookup(this.source.getMeta(), "updated");
        String dateStyle = this.getDateFormat();
        this.dateFormatted = this.formatDate(this.date, dateStyle);
        this.updatedFormatted = this.formatDate(this.updated, dateStyle);
    }

    private String getDateFormat() {
        String dateStyle = (String)this.site.getConfig().get("date_format");
        if (dateStyle == null) {
            dateStyle = "yyyy-MM-dd";
        } else if ("ordinal".equals(dateStyle)) {
            dateStyle = "MMM d yyyy";
        }
        return dateStyle;
    }

    private String formatDate(Date date, String style) {
        if (date != null) {
            if (this.site.getLocale() != null) {
                return new SimpleDateFormat(style, this.site.getLocale()).format(date);
            }
            return new SimpleDateFormat(style).format(date);
        }
        return null;
    }

    private Date lookup(Map<String, Object> frontMatter, String dateName) {
        Object date = frontMatter.get(dateName);
        if (date != null && !(date instanceof Date)) {
            String string = date.toString();
            try {
                date = f1.parse(string);
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (date == null) {
                try {
                    date = f2.parse(string);
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
        }
        return (Date)date;
    }

    @Override
    public String getOutputFileExtension() {
        return this.outputFileExtension;
    }

    public Site getSite() {
        return this.site;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    protected Converter getConverter() {
        return this.converter;
    }

    @Override
    protected Renderer getRenderer() {
        return this.site.getRenderer();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void convert() {
        this.content = this.converter.convert(this.content);
    }

    @Override
    protected void mergeRootMap(Map<String, Object> rootMap) {
        String canonical = this.site.buildCanonical(this.getUrl());
        rootMap.put("canonical", canonical);
        this.mergeHighlighterParam(rootMap);
    }

    private void mergeHighlighterParam(Map<String, Object> rootMap) {
        Highlighter highlighter = this.site.getHighlighter();
        if (highlighter != null && ".html".equals(this.outputFileExtension) && this.containsHighlightCodeBlock(highlighter)) {
            this.log.debug("The content contains highlight code block.");
            rootMap.put("highlighter", highlighter.getHighlighterName());
        }
    }

    protected boolean containsHighlightCodeBlock(Highlighter highlighter) {
        return highlighter.containsHighlightCodeBlock(this.getContent());
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getLayout() {
        return this.layout;
    }

    @Override
    public String getPermalink() {
        return this.permalink;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public String getDateFormatted() {
        return this.dateFormatted;
    }

    @Override
    public String getUpdatedFormatted() {
        return this.updatedFormatted;
    }

    public String getDate_formatted() {
        return this.getDateFormatted();
    }

    public String getUpdated_formatted() {
        return this.getUpdatedFormatted();
    }
}

