/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.Renderer;
import org.opoo.press.Site;
import org.opoo.press.SiteConfig;
import org.opoo.press.source.SourceEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererImpl
implements Renderer {
    private static final Logger log = LoggerFactory.getLogger(RendererImpl.class);
    private Configuration configuration;
    private Site site;
    private File templateDir;
    private File workingTemplateDir;
    private long start = System.currentTimeMillis();

    public RendererImpl(Site site, List<TemplateLoader> templateLoaders) {
        Map autoImportTemplates;
        this.site = site;
        this.templateDir = site.getTemplates();
        log.debug("Template directory: " + this.templateDir.getAbsolutePath());
        this.workingTemplateDir = new File(site.getWorking(), "templates");
        if (!this.workingTemplateDir.exists()) {
            this.workingTemplateDir.mkdirs();
        }
        log.debug("Working template directory: " + this.workingTemplateDir.getAbsolutePath());
        this.configuration = new Configuration();
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.configuration.setTemplateLoader(this.buildTemplateLoader(templateLoaders));
        Locale locale = site.getLocale();
        if (locale != null) {
            this.configuration.setLocale(site.getLocale());
        }
        this.configuration.addAutoImport("i18n", "i18n/messages.ftl");
        SiteConfig config = site.getConfig();
        List autoIncludeTemplates = (List)config.get("auto_include_templates");
        if (autoIncludeTemplates != null && !autoIncludeTemplates.isEmpty()) {
            for (String template : autoIncludeTemplates) {
                this.configuration.addAutoInclude(template);
                log.info("Add auto include: " + template);
            }
        }
        if ((autoImportTemplates = (Map)config.get("auto_import_templates")) != null && !autoImportTemplates.isEmpty()) {
            for (Map.Entry en : autoImportTemplates.entrySet()) {
                this.configuration.addAutoImport((String)en.getKey(), (String)en.getValue());
                log.info("Add auto import: " + (String)en.getKey() + " -> " + (String)en.getValue());
            }
        }
    }

    private TemplateLoader buildTemplateLoader(List<TemplateLoader> loaders) {
        try {
            FileTemplateLoader loader1 = new FileTemplateLoader(this.workingTemplateDir);
            FileTemplateLoader loader2 = new FileTemplateLoader(this.templateDir);
            ClassTemplateLoader loader3 = new ClassTemplateLoader(RendererImpl.class, "/org/opoo/press/templates");
            if (loaders == null) {
                loaders = new ArrayList<TemplateLoader>();
            }
            if (loaders != null) {
                loaders.add(0, (TemplateLoader)loader3);
                loaders.add(0, (TemplateLoader)loader2);
                loaders.add(0, (TemplateLoader)loader1);
            }
            TemplateLoader[] loaders2 = loaders.toArray(new TemplateLoader[loaders.size()]);
            MultiTemplateLoader loader = new MultiTemplateLoader(loaders2);
            return loader;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Site getSite() {
        return this.site;
    }

    @Override
    public String render(String templateName, Map<String, Object> rootMap) {
        StringWriter out = new StringWriter();
        this.render(templateName, rootMap, out);
        IOUtils.closeQuietly((Writer)out);
        return out.toString();
    }

    @Override
    public void render(String templateName, Map<String, Object> rootMap, Writer out) {
        Template template = null;
        try {
            template = this.configuration.getTemplate(templateName, "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.process(template, rootMap, out);
    }

    private void process(Template template, Map<String, Object> rootMap, Writer out) {
        try {
            template.process(rootMap, out);
            out.flush();
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String prepareWorkingTemplate(String layout, boolean isValidLayout, String content, boolean isContentRenderRequired, SourceEntry entry) {
        log.debug("Prepare template for " + entry.getFile());
        String name = isContentRenderRequired ? this.buildTemplateName(layout, entry) : this.buildPlainTextTemplateName(layout);
        File targetTemplateFile = new File(this.workingTemplateDir, name);
        if (targetTemplateFile.exists() && targetTemplateFile.lastModified() >= entry.getLastModified()) {
            log.debug("Working template exists and newer than source file: " + targetTemplateFile);
        } else {
            StringBuffer templateContent = this.buildTemplateContent(layout, isValidLayout, content, isContentRenderRequired);
            try {
                FileUtils.write((File)targetTemplateFile, (CharSequence)templateContent, (String)"UTF-8");
                if (log.isDebugEnabled()) {
                    log.debug("Create working template: " + targetTemplateFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Write working template error: " + targetTemplateFile, e);
            }
        }
        return name;
    }

    private String buildPlainTextTemplateName(String layout) {
        return "_" + layout + ".content.ftl";
    }

    private String buildTemplateName(String layout, SourceEntry entry) {
        String name = entry.getPath() + "/" + entry.getName() + "." + layout + ".ftl";
        return name;
    }

    private StringBuffer buildTemplateContent(String layout, boolean isValidLayout, String content, boolean isContentRenderRequired) {
        StringBuffer template = new StringBuffer();
        if (isValidLayout) {
            template.append("<#include \"/_" + layout + ".ftl\">");
            template.append("<@" + layout + "Layout>");
        }
        if (isContentRenderRequired) {
            template.append(content);
        } else {
            template.append("${content}");
        }
        if (isValidLayout) {
            template.append("</@" + layout + "Layout>");
        }
        return template;
    }

    @Override
    public String renderContent(String templateContent, Map<String, Object> rootMap) {
        StringWriter out = new StringWriter();
        this.renderContent(templateContent, rootMap, out);
        IOUtils.closeQuietly((Writer)out);
        return out.toString();
    }

    @Override
    public void renderContent(String templateContent, Map<String, Object> rootMap, Writer out) {
        Template template = null;
        try {
            template = new Template("CT" + this.start++, (Reader)new StringReader(templateContent), this.configuration, "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.process(template, rootMap, out);
    }

    @Override
    public boolean isRenderRequired(String content) {
        if (StringUtils.contains((String)content, (String)"<#")) {
            return true;
        }
        return StringUtils.contains((String)content, (String)"${");
    }

    @Override
    public boolean isValidLayout(String layout) {
        if (layout == null) {
            return false;
        }
        if ("nil".equalsIgnoreCase(layout)) {
            return false;
        }
        if ("null".equalsIgnoreCase(layout)) {
            return false;
        }
        return !"none".equalsIgnoreCase(layout);
    }
}

