/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.util.ArrayList;
import java.util.List;
import org.opoo.press.Category;
import org.opoo.press.Post;
import org.opoo.press.Site;
import org.opoo.util.URLUtils;

public class CategoryImpl
implements Category {
    private Category parent;
    private List<Category> children = new ArrayList<Category>();
    private String nicename;
    private String name;
    private List<Post> posts = new ArrayList<Post>();
    private Site site;
    private String path;
    private String title;
    private String url;

    public CategoryImpl(String nicename, String name, Site site) {
        this(nicename, name, null, site);
    }

    public CategoryImpl(String nicename, String name, Category parent, Site site) {
        this.parent = parent;
        this.nicename = nicename;
        this.name = name;
        this.site = site;
        this.init();
    }

    private void init() {
        boolean categoryTree;
        if (this.parent != null) {
            this.parent.getChildren().add(this);
        }
        this.path = (categoryTree = this.site.getConfig().get("category_tree", true).booleanValue()) && this.parent != null ? this.parent.getPath() + "." + this.nicename : this.nicename;
        if (categoryTree && this.parent != null) {
            this.url = this.parent.getUrl() + URLUtils.encodeURL(this.nicename) + "/";
        } else {
            String categoryDir = this.site.getConfig().get("category_dir", "");
            this.url = categoryDir + "/" + URLUtils.encodeURL(this.nicename) + "/";
        }
        this.title = categoryTree && this.parent != null ? this.parent.getTitle() + " &#8250; " + this.name : this.name;
    }

    @Override
    public Category getParent() {
        return this.parent;
    }

    @Override
    public List<Category> getChildren() {
        return this.children;
    }

    @Override
    public String getNicename() {
        return this.nicename;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Post> getPosts() {
        return this.posts;
    }

    @Override
    public boolean isNameOrNicename(String nameOrNicename) {
        if (nameOrNicename.equals(this.getNicename())) {
            return true;
        }
        return nameOrNicename.equals(this.getName());
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

