/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.template;

import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.opoo.press.Site;
import org.opoo.press.SiteConfig;

public class TitleCaseModel
implements TemplateMethodModel {
    private static String[] smallWords = new String[]{"a", "an", "am", "and", "as", "at", "but", "by", "en", "for", "if", "in", "of", "on", "or", "the", "to", "v", "v.", "via", "vs", "vs.", "be"};
    private static List<String> smallWordList = Arrays.asList(smallWords);
    private boolean titlecase;

    public static String toTitleCase(String string) {
        StringTokenizer st = new StringTokenizer(string);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            String str = st.nextToken();
            String lower = str.toLowerCase();
            if (sb.length() > 0 && smallWordList.contains(lower)) {
                sb.append(lower);
                continue;
            }
            sb.append((str.charAt(0) + "").toUpperCase());
            if (str.length() <= 1) continue;
            sb.append(str.substring(1));
        }
        return sb.toString();
    }

    public TitleCaseModel(Site site) {
        SiteConfig config = site.getConfig();
        this.titlecase = config.get("titlecase", false);
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments == null || arguments.isEmpty()) {
            return "";
        }
        String str = (String)arguments.get(0);
        return this.titlecase ? TitleCaseModel.toTitleCase(str) : str;
    }
}

