/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.opoo.press.Page;
import org.opoo.press.Pager;
import org.opoo.press.Post;
import org.opoo.press.Site;
import org.opoo.press.highlighter.Highlighter;
import org.opoo.press.impl.AbstractBase;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;

public class PageImpl
extends AbstractBase
implements Page {
    private Pager pager;

    public PageImpl(Site site, Source source) {
        super(site, source);
        this.resetUrl();
    }

    public PageImpl(Site site, Source source, Pager pager) {
        super(site, source);
        this.setPager(pager);
    }

    private void resetUrl() {
        String url = (String)this.getSource().getMeta().get("url");
        if (url == null) {
            SourceEntry sourceEntry = this.getSource().getSourceEntry();
            String baseName = FilenameUtils.getBaseName((String)sourceEntry.getName());
            String path = sourceEntry.getPath();
            int pageNumber = 1;
            if (this.pager != null) {
                pageNumber = this.pager.getPageNumber();
            }
            String ext = this.getOutputFileExtension();
            url = pageNumber > 1 ? ("index".equals(baseName) && ".html".equals(ext) ? path + "/page/" + pageNumber + "/" : path + "/" + baseName + "-p" + pageNumber + ext) : ("index".equals(baseName) && ".html".equals(ext) ? path + "/" : path + "/" + baseName + ext);
        }
        this.setUrl(url);
    }

    @Override
    public void setPager(Pager pager) {
        this.pager = pager;
        this.resetUrl();
    }

    @Override
    public Pager getPager() {
        return this.pager;
    }

    @Override
    protected void mergeRootMap(Map<String, Object> rootMap) {
        super.mergeRootMap(rootMap);
        rootMap.put("page", this);
        if (this.pager != null) {
            rootMap.put("paginator", this.pager);
        }
    }

    @Override
    protected boolean containsHighlightCodeBlock(Highlighter highlighter) {
        boolean contains = super.containsHighlightCodeBlock(highlighter);
        if (contains) {
            return true;
        }
        if (this.pager != null && this.pager.getPosts() != null) {
            for (Post post : this.pager.getPosts()) {
                String excerpt = post.getExcerpt();
                if (!highlighter.containsHighlightCodeBlock(excerpt)) continue;
                this.log.debug("Found highlighter code block in post excerpt: " + post.getTitle());
                return true;
            }
        }
        return false;
    }

    public Page getPage(Page current, int targetPageNumber) {
        if (current == null) {
            this.log.warn("Current page is null, cannot found target page for pagenumber " + targetPageNumber);
            return null;
        }
        Pager pa = current.getPager();
        if (pa == null) {
            this.log.warn("Current page is not one of a pigination page.");
            return null;
        }
        int currentPageNumber = pa.getPageNumber();
        if (currentPageNumber == targetPageNumber) {
            return current;
        }
        if (targetPageNumber > currentPageNumber) {
            return this.getPage(pa.getNext(), targetPageNumber);
        }
        return this.getPage(pa.getPrevious(), targetPageNumber);
    }

    public Page getPage(int targetPageNumber) {
        return this.getPage(this, targetPageNumber);
    }
}

