/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.opoo.press.Site;
import org.opoo.press.StaticFile;
import org.opoo.press.source.SourceEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileImpl
implements StaticFile {
    private static final Logger log = LoggerFactory.getLogger(StaticFileImpl.class);
    private Site site;
    private SourceEntry sourceEntry;

    public StaticFileImpl(Site site, SourceEntry sourceEntry) {
        this.site = site;
        this.sourceEntry = sourceEntry;
    }

    public Site getSite() {
        return this.site;
    }

    public void setSite(Site site) {
        this.site = site;
    }

    public SourceEntry getSourceEntry() {
        return this.sourceEntry;
    }

    public void setSourceEntry(SourceEntry sourceEntry) {
        this.sourceEntry = sourceEntry;
    }

    @Override
    public File getOutputFile(File dest) {
        String file = this.sourceEntry.getPath() + "/" + this.sourceEntry.getName();
        return new File(dest, file);
    }

    @Override
    public void write(File dest) {
        File target = this.getOutputFile(dest);
        if (target.exists() && target.length() == this.sourceEntry.getLength() && target.lastModified() >= this.sourceEntry.getLastModified()) {
            return;
        }
        try {
            File parentFile = target.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            log.debug("Copying static file to " + target);
            FileUtils.copyFile((File)this.sourceEntry.getFile(), (File)target);
        }
        catch (IOException e) {
            log.error("Copying static file error: " + target, (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

