/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.filter;

import java.util.Collections;
import java.util.List;
import org.opoo.press.Ordered;
import org.opoo.press.Page;
import org.opoo.press.Post;
import org.opoo.press.Site;
import org.opoo.press.SiteFilter;

public class MultiSiteFilter
implements SiteFilter {
    private List<SiteFilter> filters;

    public MultiSiteFilter(List<SiteFilter> filters) {
        this.filters = filters;
        if (this.filters != null) {
            Collections.sort(filters, Ordered.COMPARATOR);
        }
    }

    @Override
    public void postSetup(Site site) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postSetup(site);
            }
        }
    }

    @Override
    public void postRead(Site site) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postRead(site);
            }
        }
    }

    @Override
    public void postGenerate(Site site) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postGenerate(site);
            }
        }
    }

    @Override
    @Deprecated
    public void postRender(Site site) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postRender(site);
            }
        }
    }

    @Override
    public void postWrite(Site site) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postWrite(site);
            }
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void postConvertPost(Site site, Post post) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postConvertPost(site, post);
            }
        }
    }

    @Override
    public void postConvertPage(Site site, Page page) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postConvertPage(site, page);
            }
        }
    }

    @Override
    public void postRenderPost(Site site, Post post) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postRenderPost(site, post);
            }
        }
    }

    @Override
    public void postRenderPage(Site site, Page page) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postRenderPage(site, page);
            }
        }
    }

    @Override
    public void postRenderAllPosts(Site site) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postRenderAllPosts(site);
            }
        }
    }

    @Override
    public void postRenderAllPages(Site site) {
        if (this.filters != null) {
            for (SiteFilter f : this.filters) {
                f.postRenderAllPages(site);
            }
        }
    }
}

