/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import freemarker.template.TemplateModel;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.sf.ehcache.CacheManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.Application;
import org.opoo.press.Category;
import org.opoo.press.Converter;
import org.opoo.press.Generator;
import org.opoo.press.Page;
import org.opoo.press.Plugin;
import org.opoo.press.Post;
import org.opoo.press.RelatedPostsFinder;
import org.opoo.press.Renderer;
import org.opoo.press.Site;
import org.opoo.press.SiteBuilder;
import org.opoo.press.SiteConfig;
import org.opoo.press.SlugHelper;
import org.opoo.press.StaticFile;
import org.opoo.press.Tag;
import org.opoo.press.Writable;
import org.opoo.press.converter.IdentityConverter;
import org.opoo.press.highlighter.Highlighter;
import org.opoo.press.impl.CategoryImpl;
import org.opoo.press.impl.CosineSimilarityRelatedPostsFinder;
import org.opoo.press.impl.Draft;
import org.opoo.press.impl.PageImpl;
import org.opoo.press.impl.PostImpl;
import org.opoo.press.impl.RegistryImpl;
import org.opoo.press.impl.RendererImpl;
import org.opoo.press.impl.SiteConfigImpl;
import org.opoo.press.impl.StaticFileImpl;
import org.opoo.press.impl.TagImpl;
import org.opoo.press.plugin.DefaultPlugin;
import org.opoo.press.slug.DefaultSlugHelper;
import org.opoo.press.source.NoFrontMatterException;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;
import org.opoo.press.source.SourceEntryLoader;
import org.opoo.press.source.SourceParser;
import org.opoo.press.source.impl.EHCachedSourceParseImpl;
import org.opoo.press.source.impl.SourceParserImpl;
import org.opoo.press.task.RunnableTask;
import org.opoo.press.task.TaskExecutor;
import org.opoo.press.template.TitleCaseModel;
import org.opoo.press.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteImpl
implements Site,
SiteBuilder {
    private static final Logger log = LoggerFactory.getLogger(SiteImpl.class);
    private static final boolean IS_DEBUG_ENABLED = log.isDebugEnabled();
    private static final String LAST_BUILD_FILE_SUFFIX = "_lastbuild.properties";
    private SiteConfigImpl config;
    private Map<String, Object> data;
    private File source;
    private File dest;
    private File templates;
    private File assets;
    private File working;
    private File site;
    private List<File> sources;
    private String root;
    private List<Page> pages;
    private List<Post> posts;
    private List<StaticFile> staticFiles;
    private Map<String, Category> categories;
    private List<Tag> tags;
    private Date time;
    private boolean showDrafts = false;
    private Renderer renderer;
    private RegistryImpl registry;
    private Locale locale;
    private Highlighter highlighter;
    private SlugHelper slugHelper;
    private String permalink;
    private RelatedPostsFinder relatedPostsFinder;
    private File lastBuildInfoFile;
    private TaskExecutor taskExecutor;
    private CacheManager cacheManager;

    SiteImpl(SiteConfigImpl siteConfig) {
        this.init(siteConfig);
        this.reset();
        this.setup();
        this.postSetup();
    }

    private void postSetup() {
        this.registry.getSiteFilter().postSetup(this);
    }

    private void init(SiteConfigImpl siteConfig) {
        this.config = siteConfig;
        this.root = (String)this.config.get("root");
        this.showDrafts = this.config.get("show_drafts", false);
        if (this.showDrafts) {
            log.info("+ Show drafts option set 'ON'");
        }
        this.permalink = (String)this.config.get("permalink");
        this.data = new HashMap<String, Object>(this.config);
        boolean debug = this.config.get("debug", false);
        if (debug) {
            for (Map.Entry en : this.config.entrySet()) {
                String name = (String)en.getKey();
                name = StringUtils.leftPad((String)name, (int)25);
                log.info(name + ": " + en.getValue());
            }
        }
        this.taskExecutor = new TaskExecutor(this.config);
        if (this.config.get("cache_build", false).booleanValue()) {
            URL url = SiteImpl.class.getClassLoader().getResource("ehcache.xml");
            log.info("Cache config: {}", (Object)url);
            this.cacheManager = CacheManager.newInstance((URL)url);
            this.set("cacheManager", this.cacheManager);
            log.info("Cacheable build...");
            this.cacheManager.removeAllCaches();
            this.cacheManager.addCache("sourceContentCache");
            this.cacheManager.addCache("contentCache");
        }
    }

    private void setupDirs() {
        String destDir;
        Object siteObject = this.config.get("site");
        if (siteObject == null) {
            throw new IllegalArgumentException("Site directory not set.");
        }
        if (siteObject instanceof File) {
            this.site = (File)siteObject;
        } else {
            String siteDir = (String)siteObject;
            this.site = new File(siteDir);
        }
        if (!(this.site.exists() && this.site.isDirectory() && this.site.canRead())) {
            throw new IllegalArgumentException("Site directory not exists or not a directory: " + this.site);
        }
        this.source = new File(this.site, "source");
        if (!(this.source.exists() && this.source.isDirectory() && this.source.canRead())) {
            throw new IllegalArgumentException("Source directory not exists or not a directory.");
        }
        List sourceDirs = (List)this.config.get("sources");
        if (sourceDirs != null && !sourceDirs.isEmpty()) {
            this.sources = new ArrayList<File>();
            for (String src : sourceDirs) {
                File file = new File(this.site, src);
                if (file.exists() && file.isDirectory() && file.canRead()) {
                    this.sources.add(file);
                    log.debug("Find extra source directory: {}", (Object)file);
                    continue;
                }
                log.warn("Ignored bad extra source directory: {}", (Object)file);
            }
        }
        this.templates = new File(this.site, "templates");
        if (!this.templates.exists() || !this.templates.isDirectory()) {
            this.templates = new File(this.source, "_templates");
        }
        if (!this.templates.exists() || !this.templates.isDirectory()) {
            throw new IllegalArgumentException("No valid templates directory in site or source.");
        }
        this.assets = new File(this.site, "assets");
        if (!this.assets.exists() || !this.assets.isDirectory()) {
            this.assets = null;
        }
        this.dest = (destDir = (String)this.config.get("destination")) != null ? new File(destDir) : new File(this.site.getParentFile(), "target/public/" + this.site.getName());
        String workingDir = (String)this.config.get("working_dir");
        this.working = workingDir != null ? new File(workingDir) : new File(this.site.getParentFile(), "target/work/" + this.site.getName());
        if (this.dest.equals(this.source) || this.source.getAbsolutePath().startsWith(this.dest.getAbsolutePath())) {
            throw new IllegalArgumentException("Destination directory cannot be or contain the Source directory.");
        }
        this.lastBuildInfoFile = new File(this.working, this.site.getName() + LAST_BUILD_FILE_SUFFIX);
    }

    @Override
    public void build() {
        this.reset();
        this.read();
        this.generate();
        this.render();
        this.cleanup();
        this.write();
        this.saveLastBuildInfo();
    }

    void reset() {
        this.time = (Date)this.config.get("time");
        if (this.time == null) {
            this.time = new Date();
        }
        this.pages = new ArrayList<Page>();
        this.posts = new ArrayList<Post>();
        this.staticFiles = Collections.synchronizedList(new ArrayList());
        this.resetCategories();
        this.resetTags();
        if (this.cacheManager != null) {
            this.cacheManager.clearAll();
        }
    }

    void resetCategories() {
        this.categories = new LinkedHashMap<String, Category>();
        TreeMap names = (TreeMap)this.config.get("category_names");
        if (names == null || names.isEmpty()) {
            return;
        }
        names = new TreeMap(names);
        for (Map.Entry en : names.entrySet()) {
            String path = (String)en.getKey();
            String name = (String)en.getValue();
            String nicename = path;
            String parentPath = null;
            int index = path.lastIndexOf(46);
            if (index != -1) {
                nicename = path.substring(index + 1);
                parentPath = path.substring(0, index);
            }
            Category parent = null;
            if (parentPath != null && (parent = this.categories.get(parentPath)) == null) {
                throw new IllegalArgumentException("Parent category not found: " + parentPath);
            }
            CategoryImpl category = new CategoryImpl(nicename, name, parent, this);
            this.categories.put(path, category);
        }
    }

    void resetTags() {
        this.tags = new ArrayList<Tag>();
        Map names = (Map)this.config.get("tag_names");
        if (names == null || names.isEmpty()) {
            return;
        }
        for (Map.Entry en : names.entrySet()) {
            this.tags.add(new TagImpl((String)en.getKey(), (String)en.getValue(), this));
        }
    }

    void setup() {
        String slugHelperClassName;
        String highlighterClassName;
        this.setupDirs();
        String localeString = (String)this.config.get("locale");
        if (localeString != null) {
            this.locale = LocaleUtils.toLocale((String)localeString);
            log.debug("Set locale: " + this.locale);
        }
        if ((highlighterClassName = (String)this.config.get("highlighter")) != null) {
            this.highlighter = (Highlighter)ClassUtils.newInstance(highlighterClassName, this);
            log.debug("Set highlighter: " + highlighterClassName);
        }
        if ((slugHelperClassName = (String)this.config.get("slugHelper")) == null) {
            this.slugHelper = new DefaultSlugHelper();
            log.debug("Set SlugHelper: " + DefaultSlugHelper.class.getName());
        } else {
            this.slugHelper = Application.getContext().get(slugHelperClassName, SlugHelper.class);
            if (this.slugHelper != null) {
                log.debug("Set SlugHelper from Context object: " + this.slugHelper);
            } else {
                this.slugHelper = (SlugHelper)ClassUtils.newInstance(slugHelperClassName, this);
                log.debug("Set SlugHelper: " + slugHelperClassName);
            }
        }
        this.registry = new RegistryImpl(this);
        this.registry.registerConverter(new IdentityConverter());
        new DefaultPlugin().initialize(this.registry);
        List pluginClassNames = (List)this.config.get("plugins");
        if (pluginClassNames != null && !pluginClassNames.isEmpty()) {
            for (String className : pluginClassNames) {
                Plugin p = (Plugin)ClassUtils.newInstance(className);
                log.debug("Initializing plugin: {}", (Object)p.getClass().getName());
                p.initialize(this.registry);
            }
        }
        this.renderer = new RendererImpl(this, this.registry.getTemplateLoaders());
        String relatedPostsFinderClassName = (String)this.config.get("relatedPostsFinder");
        if (relatedPostsFinderClassName != null) {
            this.relatedPostsFinder = (RelatedPostsFinder)ClassUtils.newInstance(relatedPostsFinderClassName, this);
            log.debug("Set relatedPostsFinder: {}", (Object)relatedPostsFinderClassName);
        } else {
            this.relatedPostsFinder = new CosineSimilarityRelatedPostsFinder();
            ((CosineSimilarityRelatedPostsFinder)this.relatedPostsFinder).initialize(this);
            log.debug("Set relatedPostsFinder: {}", (Object)CosineSimilarityRelatedPostsFinder.class.getName());
        }
    }

    void read() {
        Runnable t1 = new Runnable(){

            @Override
            public void run() {
                SiteImpl.this.readSources();
            }
        };
        Runnable t2 = new Runnable(){

            @Override
            public void run() {
                SiteImpl.this.readStaticFiles();
            }
        };
        this.taskExecutor.run(t1, t2);
        this.postRead();
    }

    private void readSources() {
        log.info("Reading sources ...");
        SourceEntryLoader loader = Application.getContext().getSourceEntryLoader();
        SourceParserImpl parser = this.cacheManager != null ? new EHCachedSourceParseImpl(this.cacheManager) : new SourceParserImpl();
        FileFilter fileFilter = this.buildFilter();
        List<SourceEntry> list = loader.loadSourceEntries(this.source, fileFilter);
        if (this.sources != null && !this.sources.isEmpty()) {
            for (File src : this.sources) {
                List<SourceEntry> tempList = loader.loadSourceEntries(src, fileFilter);
                if (tempList == null || tempList.isEmpty()) continue;
                list.addAll(tempList);
            }
        }
        for (SourceEntry en : list) {
            this.read(en, parser);
        }
        Collections.sort(this.posts);
        Collections.reverse(this.posts);
        this.setPostNextOrPrevious(this.posts);
    }

    private void setPostNextOrPrevious(List<Post> posts) {
        Iterator<Post> it = posts.iterator();
        Post prev = null;
        Post curr = null;
        while (it.hasNext()) {
            curr = it.next();
            if (prev != null) {
                prev.setPrevious(curr);
                curr.setNext(prev);
            }
            prev = curr;
        }
    }

    private void readStaticFiles() {
        if (this.assets != null) {
            log.info("Reading assets ...");
            SourceEntryLoader loader = Application.getContext().getSourceEntryLoader();
            FileFilter fileFilter = this.buildFilter();
            List<SourceEntry> list = loader.loadSourceEntries(this.assets, fileFilter);
            for (SourceEntry se : list) {
                this.staticFiles.add(new StaticFileImpl(this, se));
            }
        }
    }

    private void postRead() {
        this.registry.getSiteFilter().postRead(this);
    }

    private void read(SourceEntry en, SourceParser parser) {
        try {
            Source src = parser.parse(en);
            log.debug("read source " + src.getSourceEntry().getFile());
            Map<String, Object> map = src.getMeta();
            String layout = (String)map.get("layout");
            if ("post".equals(layout)) {
                this.readPost(src);
            } else {
                this.pages.add(new PageImpl(this, src));
            }
        }
        catch (NoFrontMatterException e) {
            this.staticFiles.add(new StaticFileImpl(this, en));
        }
    }

    private void readPost(Source src) {
        if (this.isDraft(src.getMeta())) {
            if (this.showDrafts) {
                this.posts.add(new Draft(this, src));
            }
        } else {
            this.posts.add(new PostImpl(this, src));
        }
    }

    private boolean isDraft(Map<String, Object> meta) {
        if (!meta.containsKey("published")) {
            return false;
        }
        Boolean b = (Boolean)meta.get("published");
        return b == false;
    }

    FileFilter buildFilter() {
        final List includes = (List)this.config.get("includes");
        final List excludes = (List)this.config.get("excludes");
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                if (includes != null && includes.contains(name)) {
                    return true;
                }
                if (excludes != null && excludes.contains(name)) {
                    return false;
                }
                char firstChar = name.charAt(0);
                if (firstChar == '.' || firstChar == '_' || firstChar == '#') {
                    return false;
                }
                char lastChar = name.charAt(name.length() - 1);
                if (lastChar == '~') {
                    return false;
                }
                return !file.isHidden();
            }
        };
    }

    void generate() {
        for (Generator g : this.registry.getGenerators()) {
            g.generate(this);
        }
        this.postGenerate();
    }

    private void postGenerate() {
        this.registry.getSiteFilter().postGenerate(this);
    }

    void render() {
        final Map<String, Object> rootMap = this.buildRootMap();
        this.renderer.prepareLayoutWorkingTemplates();
        log.info("Rendering {} posts...", (Object)this.posts.size());
        this.taskExecutor.run(this.posts, new RunnableTask<Post>(){

            @Override
            public void run(Post post) {
                post.convert();
                SiteImpl.this.postConvertPost(post);
                post.render(rootMap);
                SiteImpl.this.postRenderPost(post);
            }
        });
        this.postRenderPosts();
        log.info("Rendering {} pages...", (Object)this.pages.size());
        this.taskExecutor.run(this.pages, new RunnableTask<Page>(){

            @Override
            public void run(Page page) {
                page.convert();
                SiteImpl.this.postConvertPage(page);
                page.render(rootMap);
                SiteImpl.this.postRenderPage(page);
            }
        });
        this.postRenderPages();
        this.postRender();
    }

    private void postConvertPost(Post post) {
        this.registry.getSiteFilter().postConvertPost(this, post);
    }

    private void postConvertPage(Page page) {
        this.registry.getSiteFilter().postConvertPage(this, page);
    }

    private void postRenderPost(Post post) {
        this.registry.getSiteFilter().postRenderPost(this, post);
    }

    private void postRenderPosts() {
        this.registry.getSiteFilter().postRenderAllPosts(this);
    }

    private void postRenderPage(Page page) {
        this.registry.getSiteFilter().postRenderPage(this, page);
    }

    private void postRenderPages() {
        this.registry.getSiteFilter().postRenderAllPages(this);
    }

    private void postRender() {
        this.registry.getSiteFilter().postRender(this);
    }

    Map<String, Object> buildRootMap() {
        Map<String, TemplateModel> models;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("site", this);
        map.put("root_url", this.getRoot());
        try {
            String version = Site.class.getPackage().getSpecificationVersion();
            if (StringUtils.isNotBlank((String)version)) {
                map.put("version", version);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (map.get("version") == null) {
            map.put("version", "unkown_version");
        }
        if ((models = this.registry.getTemplateModels()) != null && !models.isEmpty()) {
            map.putAll(models);
        }
        TitleCaseModel model = new TitleCaseModel(this);
        map.put("titleCase", model);
        map.put("titlecase", model);
        return map;
    }

    void cleanup() {
        log.info("cleanup...");
        List<File> destFiles = this.getAllDestFiles(this.dest);
        ArrayList<File> files = new ArrayList<File>();
        for (StaticFile staticFile : this.staticFiles) {
            files.add(staticFile.getOutputFile(this.dest));
        }
        log.debug("Files in target: {}", (Object)destFiles.size());
        log.debug("Asset files in src: {}", (Object)files.size());
        for (File file : files) {
            destFiles.remove(file);
        }
        if (log.isDebugEnabled()) {
            log.debug("Files in target will be deleted: " + destFiles.size());
        }
        if (!destFiles.isEmpty()) {
            this.taskExecutor.run(destFiles, new RunnableTask<File>(){

                @Override
                public void run(File file) {
                    FileUtils.deleteQuietly((File)file);
                    if (IS_DEBUG_ENABLED) {
                        log.debug("Delete file " + file);
                    }
                }
            });
        }
        this.postCleanup();
    }

    private List<File> getAllDestFiles(File dest) {
        ArrayList<File> files = new ArrayList<File>();
        if (dest != null && dest.exists()) {
            this.listDestFiles(files, dest);
        }
        return files;
    }

    private void listDestFiles(List<File> files, File dir) {
        File[] list;
        for (File f : list = dir.listFiles()) {
            if (f.isFile()) {
                files.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.listDestFiles(files, f);
        }
    }

    private void postCleanup() {
    }

    void write() {
        log.info("Writing {} posts, {} pages, and {} static files ...", new Object[]{this.posts.size(), this.pages.size(), this.staticFiles.size()});
        if (!this.dest.exists()) {
            this.dest.mkdirs();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.posts);
        list.addAll(this.pages);
        if (!this.staticFiles.isEmpty()) {
            list.addAll(this.staticFiles);
        }
        this.taskExecutor.run(list, new RunnableTask<Writable>(){

            @Override
            public void run(Writable o) {
                o.write(SiteImpl.this.dest);
            }
        });
        this.postWrite();
    }

    private void postWrite() {
        this.registry.getSiteFilter().postWrite(this);
    }

    @Override
    public List<Page> getPages() {
        return this.pages;
    }

    @Override
    public List<Post> getPosts() {
        return this.posts;
    }

    @Override
    public SiteConfig getConfig() {
        return this.config;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public List<File> getSources() {
        return this.sources;
    }

    @Override
    public File getDestination() {
        return this.dest;
    }

    @Override
    public List<StaticFile> getStaticFiles() {
        return this.staticFiles;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    @Override
    public Object get(String name) {
        return this.data.get(name);
    }

    @Override
    public void set(String name, Object value) {
        this.data.put(name, value);
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public File getTemplates() {
        return this.templates;
    }

    @Override
    public File getAssets() {
        return this.assets;
    }

    @Override
    public File getWorking() {
        return this.working;
    }

    @Override
    public Converter getConverter(Source source) {
        return this.registry.getConverter(source);
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    @Override
    public RelatedPostsFinder getRelatedPostsFinder() {
        return this.relatedPostsFinder;
    }

    @Override
    public List<Category> getCategories() {
        return new CategoriesList(this.categories);
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public String buildCanonical(String url) {
        return url;
    }

    @Override
    public String toSlug(String tagName) {
        return this.slugHelper.toSlug(tagName);
    }

    @Override
    public String toNicename(String categoryName) {
        return this.slugHelper.toSlug(categoryName);
    }

    @Override
    public Category getCategory(String categoryNameOrNicename) {
        if (this.categories == null || this.categories.isEmpty()) {
            return null;
        }
        if (this.categories.containsKey(categoryNameOrNicename)) {
            return this.categories.get(categoryNameOrNicename);
        }
        for (Category category : new ArrayList<Category>(this.categories.values())) {
            if (!category.isNameOrNicename(categoryNameOrNicename)) continue;
            return category;
        }
        return null;
    }

    @Override
    public Tag getTag(String tagNameOrSlug) {
        if (this.tags == null || this.tags.isEmpty()) {
            return null;
        }
        for (Tag tag : this.tags) {
            if (!tag.isNameOrSlug(tagNameOrSlug)) continue;
            return tag;
        }
        return null;
    }

    @Override
    public String getPermalink() {
        return this.permalink;
    }

    @Override
    public File getSite() {
        return this.site;
    }

    @Override
    public boolean showDrafts() {
        return this.showDrafts;
    }

    private void saveLastBuildInfo() {
        Properties props = new Properties();
        props.setProperty("build_time", String.valueOf(System.currentTimeMillis()));
        props.setProperty("show_drafts", String.valueOf(this.showDrafts));
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.lastBuildInfoFile);
            props.store(writer, "OpooPress last build information for site: " + this.site.getName());
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Write last build info exception", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    @Override
    public Site.BuildInfo getLastBuildInfo() {
        BuildInfoImpl buildInfoImpl;
        String val2;
        String val1;
        FileReader reader;
        block6: {
            if (!(this.lastBuildInfoFile != null && this.lastBuildInfoFile.exists() && this.lastBuildInfoFile.isFile() && this.lastBuildInfoFile.canRead())) {
                log.debug("No build info file.");
                return null;
            }
            reader = null;
            reader = new FileReader(this.lastBuildInfoFile);
            Properties props = new Properties();
            props.load(reader);
            val1 = props.getProperty("show_drafts");
            val2 = props.getProperty("build_time");
            if (!StringUtils.isBlank((String)val2) && !StringUtils.isBlank((String)val1)) break block6;
            log.debug("No show_drafts or build_time in properties file: " + this.lastBuildInfoFile);
            Site.BuildInfo buildInfo = null;
            IOUtils.closeQuietly((Reader)reader);
            return buildInfo;
        }
        try {
            BuildInfoImpl info = new BuildInfoImpl();
            info.buildTime = Long.parseLong(val2);
            info.showDrafts = Boolean.parseBoolean(val1);
            buildInfoImpl = info;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Read last build info exception", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return buildInfoImpl;
    }

    static class BuildInfoImpl
    implements Site.BuildInfo {
        private long buildTime;
        private boolean showDrafts;

        BuildInfoImpl() {
        }

        @Override
        public long getBuildTime() {
            return this.buildTime;
        }

        @Override
        public boolean showDrafts() {
            return this.showDrafts;
        }
    }

    private static class CategoriesList
    extends AbstractList<Category> {
        private final List<Category> list = new ArrayList<Category>();
        private final Map<String, Category> categories;

        private CategoriesList(Map<String, Category> categories) {
            this.categories = categories;
            for (Category category : categories.values()) {
                if (category.getPosts().isEmpty()) continue;
                this.list.add(category);
            }
        }

        @Override
        public boolean add(Category category) {
            this.categories.put(category.getPath(), category);
            return this.list.add(category);
        }

        @Override
        public Category get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

