/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.opoo.press.Category;
import org.opoo.press.Site;
import org.opoo.press.Tag;
import org.opoo.press.importer.ImportException;
import org.opoo.press.importer.Importer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordPressImporter
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(WordPressImporter.class);
    public static Namespace NS_EXCERPT = new Namespace("excerpt", "http://wordpress.org/export/1.2/excerpt/");
    public static Namespace NS_CONTENT = new Namespace("content", "http://purl.org/rss/1.0/modules/content/");
    public static Namespace NS_WFW = new Namespace("wfw", "http://wellformedweb.org/CommentAPI/");
    public static Namespace NS_DC = new Namespace("dc", "http://purl.org/dc/elements/1.1/");
    public static Namespace NS_WP = new Namespace("wp", "http://wordpress.org/export/1.2/");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat NAME_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void doImport(Site site, Map<String, Object> props) throws ImportException {
        String fileStr = (String)props.get("file");
        File file = new File(fileStr);
        if (!file.exists()) {
            throw new ImportException("File not found: " + file);
        }
        try {
            this.importFromtFile(site, file, props);
        }
        catch (DocumentException e) {
            throw new ImportException(e);
        }
        catch (FileNotFoundException e) {
            throw new ImportException(e);
        }
        catch (ParseException e) {
            throw new ImportException(e);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromtFile(Site site, File file, Map<String, Object> props) throws DocumentException, ParseException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        BufferedReader reader = new BufferedReader(inputStreamReader);
        try {
            SAXReader xmlReader = new SAXReader();
            Document doc = xmlReader.read((Reader)reader);
            Element root = doc.getRootElement();
            Element channel = root.element("channel");
            List list = channel.elements("item");
            for (Element e : list) {
                String postType = e.elementText("post_type");
                if (!"post".equals(postType) && !"page".equals(postType)) continue;
                this.importPostOrPage(site, postType, e, props);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Reader)inputStreamReader);
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    private void importPostOrPage(Site site, String postType, Element e, Map<String, Object> props) throws ParseException, IOException {
        File dir;
        File file;
        Map rp;
        StringBuilder excerptBuilder;
        boolean includeDrafts = "true".equals(props.get("include_drafts"));
        String status = e.elementTextTrim("status");
        boolean published = "publish".equals(status);
        String title = e.elementTextTrim("title");
        String name = e.elementTextTrim("post_name");
        boolean comments = "open".equals(e.elementTextTrim("comment_status"));
        String date = e.elementTextTrim("post_date");
        String author = e.elementTextTrim("creator");
        String postid = e.elementTextTrim("post_id");
        String link = e.elementTextTrim("link");
        String excerpt = e.elementTextTrim(new QName("encoded", NS_EXCERPT));
        String content = e.elementText(new QName("encoded", NS_CONTENT));
        boolean isPage = "page".equals(postType);
        Date parse = DATE_FORMAT.parse(date);
        String postname = name;
        if (postname.startsWith("%")) {
            postname = title;
        }
        String url = this.buildURL(parse, postname, postid, author, props);
        if (!includeDrafts && !published) {
            log.info(name + " is draft, skiping import. Set 'include_drafts' peroperty to enabled import drafts.");
            return;
        }
        boolean excerpted = StringUtils.isNotBlank((String)excerpt);
        StringBuilder stringBuilder = excerptBuilder = excerpted ? null : new StringBuilder();
        if (isPage) {
            excerptBuilder = null;
        }
        if ((rp = (Map)props.get("content_replacements")) != null) {
            for (Map.Entry en : rp.entrySet()) {
                content = StringUtils.replace((String)content, (String)((String)en.getKey()), (String)((String)en.getValue()));
            }
        }
        List<String> contentLines = this.processContent(content, excerptBuilder);
        if (!isPage && !excerpted) {
            excerpt = excerptBuilder.toString();
        }
        ArrayList<String> cats = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        List list = e.elements("category");
        for (Element n : list) {
            String domain = n.attributeValue("domain");
            String nicename = n.attributeValue("nicename");
            String text = n.getTextTrim();
            if ("post_tag".equals(domain)) {
                String stringTag = text;
                Tag tag = site.getTag(nicename);
                if (tag != null) {
                    stringTag = tag.getSlug();
                }
                tags.add(stringTag);
            }
            if (!"category".equals(domain)) continue;
            String stringCategory = text;
            Category category = site.getCategory(nicename);
            if (category != null) {
                stringCategory = category.getNicename();
            }
            cats.add(stringCategory);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("---");
        lines.add("layout: " + postType);
        lines.add("title: '" + title + "'");
        lines.add("comments: " + comments);
        lines.add("published: " + published);
        lines.add("date: '" + date + "'");
        if ("true".equals(props.get("include_author"))) {
            lines.add("author: " + author);
        }
        lines.add("link: " + link);
        lines.add("post_id: " + postid);
        if (url != null) {
            lines.add("url: '" + url + "'");
        }
        if (StringUtils.isNotBlank((String)excerpt)) {
            excerpt = excerpt.replace('\"', '\'');
            lines.add("excerpt: \"" + excerpt + "\"");
        }
        if (!cats.isEmpty()) {
            lines.add("categories: " + cats);
        }
        if (!tags.isEmpty()) {
            lines.add("tags: " + tags);
        }
        List meta = e.elements("postmeta");
        for (Element n : meta) {
            String key = n.elementTextTrim("meta_key");
            String value = n.elementTextTrim("meta_value");
            if (key.startsWith("_")) {
                log.debug("It's a WordPress intenal meta, skip parse: " + key);
                continue;
            }
            lines.add(key + ": \"" + value + "\"");
        }
        lines.add("---");
        lines.addAll(contentLines);
        String filename = NAME_FORMAT.format(parse) + "-" + postname + ".html";
        String importDir = (String)props.get("import_dir");
        if (StringUtils.isBlank((String)importDir)) {
            importDir = "wordpress";
        }
        if (!(file = new File(dir = site.getSource(), importDir + "/" + filename)).getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        log.info("Writing file " + file);
        FileUtils.writeLines((File)file, (String)"UTF-8", lines);
    }

    private List<String> processContent(String content, StringBuilder excerptBuilder) {
        boolean excerptFound = false;
        ArrayList<String> contentLines = new ArrayList<String>();
        boolean lastLineIsBlank = true;
        LineIterator it = IOUtils.lineIterator((Reader)new StringReader(content));
        int preCount = 0;
        while (it.hasNext()) {
            String line = it.next();
            boolean isBlank = StringUtils.isBlank((String)line);
            if (!isBlank) {
                String lower = line.toLowerCase().trim();
                if (preCount == 0 && lastLineIsBlank && !lower.startsWith("<h") && !lower.startsWith("<!--more-->")) {
                    line = "<p>" + line;
                }
                contentLines.add(line);
                if (excerptBuilder != null) {
                    int indexOf = line.indexOf("<!--more-->");
                    if (indexOf >= 0) {
                        excerptBuilder.append(line.substring(0, indexOf));
                        excerptFound = true;
                    } else if (!excerptFound) {
                        excerptBuilder.append(line);
                    }
                }
                if (lower.contains("<pre>") || lower.contains("<pre ")) {
                    ++preCount;
                }
                if (lower.contains("</pre>")) {
                    --preCount;
                }
                lastLineIsBlank = false;
                continue;
            }
            lastLineIsBlank = true;
            contentLines.add(line);
        }
        return contentLines;
    }

    private String buildURL(Date date, String postname, String post_id, String author, Map<String, Object> props) {
        String permalinkStyle = (String)props.get("permalink_style");
        if (StringUtils.isBlank((String)permalinkStyle)) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        int monthnum = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)"%postname%", (String)postname);
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)"%post_id%", (String)post_id);
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)"%author%", (String)author);
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)"%year%", (String)(year + ""));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)"%monthnum%", (String)StringUtils.leftPad((String)(monthnum + ""), (int)2, (char)'0'));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)"%day%", (String)StringUtils.leftPad((String)(day + ""), (int)2, (char)'0'));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)"%hour%", (String)StringUtils.leftPad((String)(hour + ""), (int)2, (char)'0'));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)"%minute%", (String)StringUtils.leftPad((String)(minute + ""), (int)2, (char)'0'));
        permalinkStyle = StringUtils.replace((String)permalinkStyle, (String)"%second%", (String)StringUtils.leftPad((String)(second + ""), (int)2, (char)'0'));
        return permalinkStyle;
    }
}

