/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.source.impl;

import java.io.Serializable;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;

public class EHCachedSource
implements Source {
    private final Map<String, Object> frontMatter;
    private final Cache sourceContentCache;
    private final SourceEntry sourceEntry;

    EHCachedSource(SourceEntry sourceEntry, Map<String, Object> frontMatter, String content, Cache sourceContentCache) {
        this.frontMatter = frontMatter;
        this.sourceEntry = sourceEntry;
        this.sourceContentCache = sourceContentCache;
        String key = sourceEntry.getFile().getAbsolutePath();
        sourceContentCache.put(new Element((Serializable)((Object)key), (Serializable)((Object)content)));
    }

    @Override
    public SourceEntry getSourceEntry() {
        return this.sourceEntry;
    }

    @Override
    public Map<String, Object> getMeta() {
        return this.frontMatter;
    }

    @Override
    public String getContent() {
        String key = this.sourceEntry.getFile().getAbsolutePath();
        Element element = this.sourceContentCache.get((Serializable)((Object)key));
        if (element != null) {
            return (String)element.getObjectValue();
        }
        return null;
    }
}

