/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.source.impl;

import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;
import org.opoo.press.source.impl.EHCachedSource;
import org.opoo.press.source.impl.SourceParserImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHCachedSourceParseImpl
extends SourceParserImpl {
    private static final Logger log = LoggerFactory.getLogger(EHCachedSourceParseImpl.class);
    private final Cache sourceContentCache;

    public EHCachedSourceParseImpl(Cache sourceContentCache) {
        this.sourceContentCache = sourceContentCache;
        log.info("Using source parser: {}", (Object)EHCachedSourceParseImpl.class.getName());
    }

    public EHCachedSourceParseImpl(CacheManager cacheManager) {
        this(cacheManager.getCache("sourceContentCache"));
    }

    @Override
    protected Source createSource(SourceEntry sourceEntry, Map<String, Object> map, String content) {
        return new EHCachedSource(sourceEntry, map, content, this.sourceContentCache);
    }
}

