/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.source.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;
import org.opoo.press.source.SourceManager;
import org.opoo.press.source.impl.SimpleSource;
import org.yaml.snakeyaml.Yaml;

public class SourceManagerImpl
implements SourceManager {
    private Yaml yaml = new Yaml();

    public void setYaml(Yaml yaml) {
    }

    @Override
    public void saveSourceToFile(Source source) {
        File file = source.getSourceEntry().getFile();
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("Can not save file, '" + dir + "' is not a valid directory.");
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("---");
        String line = this.yaml.dumpAsMap(source.getMeta());
        lines.add(line);
        lines.add("---");
        lines.add(source.getContent());
        try {
            FileUtils.writeLines((File)file, (String)"UTF-8", lines);
        }
        catch (IOException e) {
            throw new RuntimeException("Write file exception", e);
        }
    }

    @Override
    public SourceEntry buildEntry(File sourceDir, String path) {
        path = FilenameUtils.separatorsToUnix((String)path);
        String[] arr = StringUtils.split((String)path, (String)"/");
        SourceEntry entry = null;
        for (String s : arr) {
            sourceDir = new File(sourceDir, s);
            entry = new SourceEntry(entry, sourceDir);
        }
        return entry;
    }

    @Override
    public Source buildSource(File sourceDir, String path, Map<String, Object> meta, String content) {
        SourceEntry entry = this.buildEntry(sourceDir, path);
        return new SimpleSource(entry, meta, content);
    }
}

