/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.source.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.opoo.press.source.NoFrontMatterException;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;
import org.opoo.press.source.SourceParser;
import org.opoo.press.source.impl.SimpleSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SourceParserImpl
implements SourceParser {
    private static final Logger log = LoggerFactory.getLogger(SourceParserImpl.class);
    private Yaml yaml = new Yaml();

    public Yaml getYaml() {
        return this.yaml;
    }

    public void setYaml(Yaml yaml) {
        this.yaml = yaml;
    }

    @Override
    public Source parse(SourceEntry sourceEntry) throws NoFrontMatterException {
        ArrayList<String> metaLines = new ArrayList<String>();
        ArrayList contentLines = new ArrayList();
        FileInputStream stream = null;
        ArrayList<String> currentList = metaLines;
        try {
            stream = new FileInputStream(sourceEntry.getFile());
            LineIterator iterator = IOUtils.lineIterator((InputStream)stream, (String)"UTF-8");
            if (!iterator.hasNext()) {
                throw new RuntimeException("File not content: " + sourceEntry.getFile());
            }
            String line = iterator.next();
            if (!SourceParserImpl.isFrontMatterStartLine(line, sourceEntry)) {
                log.debug("Maybe a static file: " + sourceEntry.getFile());
                throw new NoFrontMatterException(sourceEntry);
            }
            boolean hasFrontMatterEndLine = false;
            while (iterator.hasNext()) {
                line = iterator.next();
                if (SourceParserImpl.isFrontMatterEndLine(line)) {
                    hasFrontMatterEndLine = true;
                    currentList = contentLines;
                    continue;
                }
                currentList.add(line);
            }
            if (!hasFrontMatterEndLine) {
                log.debug("Maybe a static file: " + sourceEntry.getFile());
                throw new NoFrontMatterException(sourceEntry);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        StringWriter metaWriter = new StringWriter();
        StringWriter contentWriter = new StringWriter();
        try {
            IOUtils.writeLines(metaLines, null, (Writer)metaWriter);
            IOUtils.writeLines(contentLines, null, (Writer)contentWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Writer)contentWriter);
            IOUtils.closeQuietly((Writer)metaWriter);
        }
        Map map = (Map)this.yaml.load(metaWriter.toString());
        String content = contentWriter.toString();
        return this.createSource(sourceEntry, map, content);
    }

    protected Source createSource(SourceEntry sourceEntry, Map<String, Object> map, String content) {
        return new SimpleSource(sourceEntry, map, content);
    }

    private static boolean isFrontMatterStartLine(String line, SourceEntry sourceEntry) {
        if ("---".equals(line)) {
            return true;
        }
        if (line.length() == 4 && '\ufeff' == line.charAt(0) && "---".equals(line.substring(1))) {
            log.debug("UTF-8 with BOM file: " + sourceEntry.getFile());
            return true;
        }
        return false;
    }

    private static boolean isFrontMatterEndLine(String line) {
        return "---".equals(line);
    }
}

