/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opoo.press.impl.SiteConfigImpl;
import org.opoo.press.task.CallableTask;
import org.opoo.press.task.RunnableTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutor {
    public static final int DEFAULT_THREADS = 1;
    private static final Logger log = LoggerFactory.getLogger(TaskExecutor.class);
    private ExecutorService executorService;

    public TaskExecutor(SiteConfigImpl config) {
        int threadsCount = Integer.parseInt(System.getProperty("threads", "-1"));
        if (threadsCount <= 0) {
            threadsCount = config.get("threads", 1);
        }
        if (threadsCount <= 0) {
            threadsCount = 1;
        }
        if (threadsCount > 1) {
            this.executorService = Executors.newFixedThreadPool(threadsCount);
            log.info("Executing build in threads: " + threadsCount);
        } else {
            log.info("Executing build in single thread.");
        }
    }

    public void run(Runnable task) {
        if (this.executorService == null) {
            task.run();
            return;
        }
        Future<?> future = this.executorService.submit(task);
        try {
            future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <V> V call(Callable<V> task) throws Exception {
        if (this.executorService == null) {
            return task.call();
        }
        Future<V> future = this.executorService.submit(task);
        return future.get();
    }

    public <T> void run(Collection<T> list, final RunnableTask<T> task) {
        if (this.executorService == null) {
            for (T t : list) {
                task.run(t);
            }
            return;
        }
        int size = list.size();
        ExecutorCompletionService<Integer> cs = new ExecutorCompletionService<Integer>(this.executorService);
        for (final T input : list) {
            cs.submit(new Runnable(){

                @Override
                public void run() {
                    task.run(input);
                }
            }, 1);
        }
        try {
            for (int i = 0; i < size; ++i) {
                cs.take().get();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T, V> List<V> call(Collection<T> list, final CallableTask<T, V> task) {
        ArrayList result = new ArrayList();
        if (this.executorService == null) {
            for (T t : list) {
                result.add(task.call(t));
            }
            return result;
        }
        int size = list.size();
        ExecutorCompletionService cs = new ExecutorCompletionService(this.executorService);
        for (final T input : list) {
            cs.submit(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return task.call(input);
                }
            });
        }
        try {
            for (int i = 0; i < size; ++i) {
                result.add(cs.take().get());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void run(Runnable ... tasks) {
        ArrayList<Runnable> taskList = new ArrayList<Runnable>();
        for (Runnable task : tasks) {
            taskList.add(task);
        }
        this.run(taskList);
    }

    public void run(List<Runnable> tasks) {
        if (this.executorService == null) {
            for (Runnable t : tasks) {
                t.run();
            }
            return;
        }
        int size = tasks.size();
        ExecutorCompletionService<Integer> cs = new ExecutorCompletionService<Integer>(this.executorService);
        for (Runnable task : tasks) {
            cs.submit(task, 1);
        }
        try {
            for (int i = 0; i < size; ++i) {
                cs.take().get();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

