/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.converter;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.opoo.press.Converter;
import org.opoo.press.Source;

public abstract class AbstractWikiTextConverter
implements Converter {
    public String convert(String content) {
        MarkupParser parser = this.getMarkupParser();
        StringWriter writer = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)writer);
        builder.setEmitAsDocument(false);
        parser.setBuilder((DocumentBuilder)builder);
        parser.parse(content);
        parser.setBuilder(null);
        return writer.toString();
    }

    protected abstract MarkupParser getMarkupParser();

    public String getOutputFileExtension(Source src) {
        return ".html";
    }

    public boolean matches(Source src) {
        String name = src.getSourceEntry().getName().toLowerCase();
        String[] extensions = this.getInputFileExtensions();
        if (extensions.length == 1) {
            return FilenameUtils.isExtension((String)name, (String)extensions[0]);
        }
        return FilenameUtils.isExtension((String)name, (String[])extensions);
    }

    protected abstract String[] getInputFileExtensions();
}

