/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.converter;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.opoo.press.Converter;
import org.opoo.press.Highlighter;
import org.opoo.press.Site;
import org.opoo.press.SiteAware;
import org.opoo.press.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtmarkMarkdownConverter
implements Converter,
SiteAware {
    private static final Logger log = LoggerFactory.getLogger(TxtmarkMarkdownConverter.class);
    private Configuration config;
    private Highlighter highlighter;

    public void setSite(Site site) {
        this.highlighter = site.getFactory().getHighlighter();
        if (this.highlighter == null) {
            log.warn("This converter might be need a Highlighter.");
        } else {
            this.config = Configuration.builder().setCodeBlockEmitter((BlockEmitter)new BlockEmitterImpl(this.highlighter)).forceExtentedProfile().build();
        }
    }

    public int getOrder() {
        return 100;
    }

    public boolean matches(Source src) {
        String name = src.getSourceEntry().getName().toLowerCase();
        if (FilenameUtils.isExtension((String)name, (String[])new String[]{"markdown", "md"})) {
            return true;
        }
        return "post".equals(src.getMeta().get("layout")) && FilenameUtils.isExtension((String)name, (String)"txt");
    }

    public String convert(String content) {
        if (this.config != null) {
            return Processor.process((String)content, (Configuration)this.config);
        }
        return Processor.process((String)content);
    }

    public String getOutputFileExtension(Source src) {
        return ".html";
    }

    private static class BlockEmitterImpl
    implements BlockEmitter {
        private Highlighter highlighter;

        public BlockEmitterImpl(Highlighter highlighter) {
            this.highlighter = highlighter;
        }

        public void emitBlock(StringBuilder out, List<String> lines, String meta) {
            this.highlighter.highlight(out, lines, meta);
        }
    }
}

