/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Result {
    private final List<File> updatedFiles = new ArrayList<File>();
    private final List<File> createdFiles = new ArrayList<File>();
    private final List<File> deletedFiles = new ArrayList<File>();
    private int size = 0;

    private Result() {
    }

    public static Result newResult() {
        return new Result();
    }

    Result addUpdatedFile(File file) {
        this.updatedFiles.add(file);
        ++this.size;
        return this;
    }

    Result addCreatedFile(File file) {
        this.createdFiles.add(file);
        ++this.size;
        return this;
    }

    Result addDeletedFile(File file) {
        this.deletedFiles.add(file);
        ++this.size;
        return this;
    }

    public Result addResult(Result result) {
        this.deletedFiles.addAll(result.deletedFiles);
        this.updatedFiles.addAll(result.updatedFiles);
        this.createdFiles.addAll(result.createdFiles);
        this.size = this.updatedFiles.size() + this.createdFiles.size() + this.deletedFiles.size();
        return this;
    }

    public List<File> getUpdatedFiles() {
        return this.updatedFiles;
    }

    public List<File> getCreatedFiles() {
        return this.createdFiles;
    }

    public List<File> getDeletedFiles() {
        return this.deletedFiles;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.updatedFiles.clear();
        this.createdFiles.clear();
        this.deletedFiles.clear();
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String toString() {
        if (this.size == 0) {
            return "No file changed.";
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        for (File f : this.updatedFiles) {
            buffer.append("updated  ").append(f).append(lineSeparator);
        }
        for (File f : this.createdFiles) {
            buffer.append("created  ").append(f).append(lineSeparator);
        }
        for (File f : this.deletedFiles) {
            buffer.append("deleted  ").append(f).append(lineSeparator);
        }
        return buffer.toString();
    }
}

