/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.file;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.opoo.press.file.Result;
import org.opoo.press.file.Watchable;

public class WatchableDirectory
extends FileAlterationListenerAdaptor
implements Watchable {
    private final File directory;
    private final FileFilter fileFilter;
    private Result result;
    private FileAlterationObserver fileAlterationObserver;

    public WatchableDirectory(String directoryName) {
        this(new File(directoryName));
    }

    public WatchableDirectory(String directoryName, FileFilter fileFilter) {
        this(new File(directoryName), fileFilter);
    }

    public WatchableDirectory(File directory) {
        this(directory, (FileFilter)null);
    }

    public WatchableDirectory(File directory, FileFilter fileFilter) {
        this.directory = directory;
        this.fileFilter = fileFilter;
    }

    @Override
    public void initialize() {
        this.fileAlterationObserver = new FileAlterationObserver(this.directory, this.fileFilter);
        this.fileAlterationObserver.addListener((FileAlterationListener)this);
        try {
            this.fileAlterationObserver.initialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Result check() {
        this.result = Result.newResult();
        this.fileAlterationObserver.checkAndNotify();
        return this.result;
    }

    @Override
    public void destroy() {
        this.result = null;
        try {
            this.fileAlterationObserver.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onFileCreate(File file) {
        this.result.addCreatedFile(file);
    }

    public void onFileChange(File file) {
        this.result.addUpdatedFile(file);
    }

    public void onFileDelete(File file) {
        this.result.addDeletedFile(file);
    }
}

