/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.file;

import java.io.File;
import org.apache.commons.io.monitor.FileEntry;
import org.opoo.press.file.Result;
import org.opoo.press.file.Watchable;

public class WatchableFiles
implements Watchable {
    private FileEntry[] entries;

    public WatchableFiles(File ... files) {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("files are required.");
        }
        this.entries = new FileEntry[files.length];
        for (int i = 0; i < files.length; ++i) {
            this.entries[i] = new FileEntry(files[i]);
        }
    }

    @Override
    public void initialize() {
        for (FileEntry entry : this.entries) {
            entry.refresh(entry.getFile());
        }
    }

    @Override
    public Result check() {
        Result result = Result.newResult();
        for (FileEntry entry : this.entries) {
            if (!entry.refresh(entry.getFile())) continue;
            result.addUpdatedFile(entry.getFile());
        }
        return result;
    }

    @Override
    public void destroy() {
    }
}

