/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.generator;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opoo.press.Generator;
import org.opoo.press.Page;
import org.opoo.press.Pager;
import org.opoo.press.Post;
import org.opoo.press.Renderer;
import org.opoo.press.Site;
import org.opoo.press.Source;
import org.opoo.press.Tag;
import org.opoo.press.impl.AbstractConvertible;
import org.opoo.util.I18NUtills;
import org.opoo.util.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagGenerator
implements Generator {
    private static final Logger log = LoggerFactory.getLogger(TagGenerator.class);

    public int getOrder() {
        return 300;
    }

    public void generate(Site site) {
        log.debug("Generating tag pages...");
        List tags = site.getTags();
        String tagPageTitlePrefix = this.getTagPageTitlePrefix(site);
        String template = this.getTagPageTemplate(site);
        for (Tag tag : tags) {
            List posts = tag.getPosts();
            if (posts.isEmpty()) continue;
            Collections.sort(posts);
            Collections.reverse(posts);
            TagPage page = new TagPage(site, template);
            page.setTitle(tagPageTitlePrefix + tag.getName());
            page.setUrl(tag.getUrl());
            page.setPosts(posts);
            site.getPages().add(page);
        }
    }

    private String getTagPageTitlePrefix(Site site) {
        String prefix = I18NUtills.getString("messages", site.getLocale(), "tag.page.title.prefix");
        if (prefix == null) {
            prefix = (String)site.getConfig().get("tag_page_title_prefix", (Object)"");
        }
        return prefix;
    }

    private String getTagPageTemplate(Site site) {
        return (String)site.getConfig().get("tag_page_template", (Object)"tag.ftl");
    }

    public static class TagPage
    extends AbstractConvertible
    implements Page {
        private String url;
        private Renderer renderer;
        private Site site;
        private String content;
        private String title;
        private List<Post> posts;
        private String template;

        public TagPage(Site site, String template) {
            this.site = site;
            this.renderer = site.getRenderer();
            this.template = template;
        }

        @Override
        public void render(Map<String, Object> rootMap) {
            rootMap = new HashMap<String, Object>(rootMap);
            this.mergeRootMap(rootMap);
            String output = this.getRenderer().render(this.template, rootMap);
            this.setContent(output);
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public Source getSource() {
            return null;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        public String getPath() {
            return null;
        }

        @Override
        public String getLayout() {
            return "nil";
        }

        public String getPermalink() {
            return null;
        }

        public Date getDate() {
            return null;
        }

        public Date getUpdated() {
            return null;
        }

        public String getDateFormatted() {
            return null;
        }

        public String getUpdatedFormatted() {
            return null;
        }

        public Pager getPager() {
            return null;
        }

        public void setPager(Pager pager) {
        }

        @Override
        public void setContent(String content) {
            this.content = content;
        }

        @Override
        public String getOutputFileExtension() {
            return ".html";
        }

        @Override
        protected Renderer getRenderer() {
            return this.renderer;
        }

        public void convert() {
        }

        @Override
        protected void mergeRootMap(Map<String, Object> rootMap) {
            rootMap.put("canonical", this.site.buildCanonical(this.getUrl()));
            rootMap.put("page", this);
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public List<Post> getPosts() {
            return this.posts;
        }

        public void setPosts(List<Post> posts) {
            this.posts = posts;
        }

        public boolean isFooter() {
            return false;
        }

        public boolean isSidebar() {
            return true;
        }

        public Object get(String string) {
            return null;
        }

        @Override
        public File getOutputFile(File dest) {
            String url = this.getUrl() + "index.html";
            url = URLUtils.decodeURL(url);
            File target = new File(dest, url);
            return target;
        }

        public boolean isComments() {
            return false;
        }

        public void set(String name, Object value) {
        }
    }
}

